/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockReader;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Transition;

public class IntersectBlockReader
extends BlockReader {
    protected final int NUM_CONSECUTIVELY_REJECTED_TERMS_THRESHOLD = 4;
    protected final Automaton automaton;
    protected final ByteRunAutomaton runAutomaton;
    protected final boolean finite;
    protected final BytesRef commonSuffix;
    protected final int minTermLength;
    protected final AutomatonNextTermCalculator nextStringCalculator;
    protected BytesRef seekTerm;
    protected int numMatchedBytes;
    protected int[] states;
    protected BlockIteration blockIteration;
    protected int numConsecutivelyRejectedTerms;

    protected IntersectBlockReader(CompiledAutomaton compiled, BytesRef startTerm, IndexDictionary.BrowserSupplier dictionaryBrowserSupplier, IndexInput blockInput, PostingsReaderBase postingsReader, FieldMetadata fieldMetadata, BlockDecoder blockDecoder) throws IOException {
        super(dictionaryBrowserSupplier, blockInput, postingsReader, fieldMetadata, blockDecoder);
        this.automaton = compiled.automaton;
        this.runAutomaton = compiled.runAutomaton;
        this.finite = compiled.finite;
        this.commonSuffix = compiled.commonSuffixRef;
        this.minTermLength = this.getMinTermLength();
        this.nextStringCalculator = new AutomatonNextTermCalculator(compiled);
        this.seekTerm = startTerm;
    }

    protected int getMinTermLength() {
        int commonSuffixLength;
        int n = commonSuffixLength = this.commonSuffix == null ? 0 : this.commonSuffix.length;
        if (!this.finite) {
            return commonSuffixLength;
        }
        int commonPrefixLength = 0;
        int state = 0;
        Transition t = null;
        while (true) {
            if (this.runAutomaton.isAccept(state)) {
                return Math.max(commonPrefixLength, commonSuffixLength);
            }
            if (this.automaton.getNumTransitions(state) != 1) break;
            if (t == null) {
                t = new Transition();
            }
            this.automaton.getTransition(state, 0, t);
            if (t.min != t.max) break;
            state = t.dest;
            ++commonPrefixLength;
        }
        return commonPrefixLength + commonSuffixLength;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.blockHeader == null) {
            if (!this.seekFirstBlock()) {
                return null;
            }
            this.states = new int[32];
            this.blockIteration = BlockIteration.NEXT;
        }
        this.termState = null;
        do {
            BytesRef term;
            if ((term = this.nextTermInBlockMatching()) == null) continue;
            return term;
        } while (this.nextBlock());
        return null;
    }

    protected boolean seekFirstBlock() throws IOException {
        this.seekTerm = this.nextStringCalculator.nextSeekTerm(this.seekTerm);
        if (this.seekTerm == null) {
            return false;
        }
        long blockStartFP = this.getOrCreateDictionaryBrowser().seekBlock(this.seekTerm);
        if (blockStartFP == -1L) {
            blockStartFP = this.fieldMetadata.getFirstBlockStartFP();
        } else if (this.isBeyondLastTerm(this.seekTerm, blockStartFP)) {
            return false;
        }
        this.initializeHeader(this.seekTerm, blockStartFP);
        return this.blockHeader != null;
    }

    protected BytesRef nextTermInBlockMatching() throws IOException {
        if (this.seekTerm == null) {
            if (this.readLineInBlock() == null) {
                return null;
            }
        } else {
            TermsEnum.SeekStatus seekStatus = this.seekInBlock(this.seekTerm);
            this.seekTerm = null;
            if (seekStatus == TermsEnum.SeekStatus.END) {
                return null;
            }
            assert (this.numMatchedBytes == 0);
            assert (this.numConsecutivelyRejectedTerms == 0);
        }
        while (true) {
            TermBytes lineTermBytes = this.blockLine.getTermBytes();
            BytesRef lineTerm = lineTermBytes.getTerm();
            assert (lineTerm.offset == 0);
            if (this.states.length <= lineTerm.length) {
                this.states = ArrayUtil.growExact(this.states, ArrayUtil.oversize(lineTerm.length + 1, 1));
            }
            int index = Math.min(lineTermBytes.getSuffixOffset(), this.numMatchedBytes);
            if (lineTerm.length >= this.minTermLength && (this.commonSuffix == null || this.endsWithCommonSuffix(lineTerm.bytes, lineTerm.length))) {
                int state = this.states[index];
                while (true) {
                    if (index == lineTerm.length) {
                        if (!this.runAutomaton.isAccept(state)) break;
                        assert (this.runAutomaton.run(lineTerm.bytes, 0, lineTerm.length));
                        this.numMatchedBytes = index;
                        if (this.numConsecutivelyRejectedTerms > 0) {
                            this.numConsecutivelyRejectedTerms = 0;
                        }
                        assert (this.blockIteration == BlockIteration.NEXT);
                        return lineTerm;
                    }
                    if ((state = this.runAutomaton.step(state, lineTerm.bytes[index] & 0xFF)) == -1) break;
                    this.states[++index] = state;
                }
            }
            assert (!this.runAutomaton.run(lineTerm.bytes, 0, lineTerm.length));
            this.numMatchedBytes = index;
            if (++this.numConsecutivelyRejectedTerms >= 4 && this.lineIndexInBlock < this.blockHeader.getLinesCount() - 1 && !this.nextStringCalculator.isLinearState(lineTerm)) {
                this.seekTerm = this.nextStringCalculator.nextSeekTerm(lineTerm);
                if (this.seekTerm == null) {
                    this.blockIteration = BlockIteration.END;
                    return null;
                }
                this.readLineInBlock();
                if (this.seekTerm.compareTo(this.blockLine.getTermBytes().getTerm()) > 0) {
                    this.blockIteration = BlockIteration.SEEK;
                    return null;
                }
                this.seekTerm = null;
                this.numConsecutivelyRejectedTerms = Integer.MIN_VALUE;
                continue;
            }
            if (this.readLineInBlock() == null) break;
        }
        assert (this.blockIteration == BlockIteration.NEXT);
        return null;
    }

    protected boolean endsWithCommonSuffix(byte[] termBytes, int termLength) {
        byte[] suffixBytes = this.commonSuffix.bytes;
        int suffixLength = this.commonSuffix.length;
        int offset = termLength - suffixLength;
        assert (offset >= 0);
        for (int i = 0; i < suffixLength; ++i) {
            if (termBytes[offset + i] == suffixBytes[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean nextBlock() throws IOException {
        long blockStartFP;
        switch (this.blockIteration) {
            case NEXT: {
                assert (this.seekTerm == null);
                blockStartFP = this.blockInput.getFilePointer();
                break;
            }
            case SEEK: {
                assert (this.seekTerm != null);
                blockStartFP = this.getOrCreateDictionaryBrowser().seekBlock(this.seekTerm);
                if (this.isBeyondLastTerm(this.seekTerm, blockStartFP)) {
                    return false;
                }
                this.blockIteration = BlockIteration.NEXT;
                break;
            }
            case END: {
                return false;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported " + BlockIteration.class.getSimpleName());
            }
        }
        this.numMatchedBytes = 0;
        this.numConsecutivelyRejectedTerms = 0;
        this.initializeHeader(this.seekTerm, blockStartFP);
        return this.blockHeader != null;
    }

    @Override
    public boolean seekExact(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(BytesRef term, TermState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    protected class AutomatonNextTermCalculator {
        protected final short[] visited;
        protected short curGen;
        protected final BytesRefBuilder seekBytesRef = new BytesRefBuilder();
        protected boolean linear;
        protected final BytesRef linearUpperBound = new BytesRef();
        protected final Transition transition = new Transition();
        protected final IntsRefBuilder savedStates = new IntsRefBuilder();

        protected AutomatonNextTermCalculator(CompiledAutomaton compiled) {
            this.visited = compiled.finite != false ? null : new short[IntersectBlockReader.this.runAutomaton.getSize()];
        }

        protected void setVisited(int state) {
            if (!IntersectBlockReader.this.finite) {
                this.visited[state] = this.curGen;
            }
        }

        protected boolean isVisited(int state) {
            return !IntersectBlockReader.this.finite && this.visited[state] == this.curGen;
        }

        protected boolean isLinearState(BytesRef term) {
            return this.linear && term.compareTo(this.linearUpperBound) < 0;
        }

        protected BytesRef nextSeekTerm(BytesRef term) {
            if (term == null) {
                assert (this.seekBytesRef.length() == 0);
                if (IntersectBlockReader.this.runAutomaton.isAccept(0)) {
                    return this.seekBytesRef.get();
                }
            } else {
                this.seekBytesRef.copyBytes(term);
            }
            if (this.nextString()) {
                return this.seekBytesRef.get();
            }
            return null;
        }

        protected void setLinear(int position) {
            int length;
            assert (!this.linear);
            int state = 0;
            int maxInterval = 255;
            for (int i = 0; i < position; ++i) {
                state = IntersectBlockReader.this.runAutomaton.step(state, this.seekBytesRef.byteAt(i) & 0xFF);
                assert (state >= 0) : "state=" + state;
            }
            int numTransitions = IntersectBlockReader.this.automaton.getNumTransitions(state);
            IntersectBlockReader.this.automaton.initTransition(state, this.transition);
            for (int i = 0; i < numTransitions; ++i) {
                IntersectBlockReader.this.automaton.getNextTransition(this.transition);
                if (this.transition.min > (this.seekBytesRef.byteAt(position) & 0xFF) || (this.seekBytesRef.byteAt(position) & 0xFF) > this.transition.max) continue;
                maxInterval = this.transition.max;
                break;
            }
            if (maxInterval != 255) {
                ++maxInterval;
            }
            if (this.linearUpperBound.bytes.length < (length = position + 1)) {
                this.linearUpperBound.bytes = new byte[ArrayUtil.oversize(length, 1)];
            }
            System.arraycopy(this.seekBytesRef.bytes(), 0, this.linearUpperBound.bytes, 0, position);
            this.linearUpperBound.bytes[position] = (byte)maxInterval;
            this.linearUpperBound.length = length;
            this.linear = true;
        }

        protected boolean nextString() {
            int pos = 0;
            this.savedStates.grow(this.seekBytesRef.length() + 1);
            this.savedStates.setIntAt(0, 0);
            while (true) {
                if (!IntersectBlockReader.this.finite && (this.curGen = (short)(this.curGen + 1)) == 0) {
                    Arrays.fill(this.visited, (short)-1);
                }
                this.linear = false;
                int state = this.savedStates.intAt(pos);
                while (pos < this.seekBytesRef.length()) {
                    this.setVisited(state);
                    int nextState = IntersectBlockReader.this.runAutomaton.step(state, this.seekBytesRef.byteAt(pos) & 0xFF);
                    if (nextState == -1) break;
                    this.savedStates.setIntAt(pos + 1, nextState);
                    if (!this.linear && this.isVisited(nextState)) {
                        this.setLinear(pos);
                    }
                    state = nextState;
                    ++pos;
                }
                if (this.nextString(state, pos)) {
                    return true;
                }
                if ((pos = this.backtrack(pos)) < 0) {
                    return false;
                }
                int newState = IntersectBlockReader.this.runAutomaton.step(this.savedStates.intAt(pos), this.seekBytesRef.byteAt(pos) & 0xFF);
                if (newState >= 0 && IntersectBlockReader.this.runAutomaton.isAccept(newState)) {
                    return true;
                }
                if (IntersectBlockReader.this.finite) continue;
                pos = 0;
            }
        }

        protected boolean nextString(int state, int position) {
            int c = 0;
            if (position < this.seekBytesRef.length()) {
                c = this.seekBytesRef.byteAt(position) & 0xFF;
                if (c++ == 255) {
                    return false;
                }
            }
            this.seekBytesRef.setLength(position);
            this.setVisited(state);
            int numTransitions = IntersectBlockReader.this.automaton.getNumTransitions(state);
            IntersectBlockReader.this.automaton.initTransition(state, this.transition);
            for (int i = 0; i < numTransitions; ++i) {
                IntersectBlockReader.this.automaton.getNextTransition(this.transition);
                if (this.transition.max < c) continue;
                int nextChar = Math.max(c, this.transition.min);
                this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
                this.seekBytesRef.append((byte)nextChar);
                state = this.transition.dest;
                while (!this.isVisited(state) && !IntersectBlockReader.this.runAutomaton.isAccept(state)) {
                    this.setVisited(state);
                    IntersectBlockReader.this.automaton.initTransition(state, this.transition);
                    IntersectBlockReader.this.automaton.getNextTransition(this.transition);
                    state = this.transition.dest;
                    this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
                    this.seekBytesRef.append((byte)this.transition.min);
                    if (this.linear || !this.isVisited(state)) continue;
                    this.setLinear(this.seekBytesRef.length() - 1);
                }
                return true;
            }
            return false;
        }

        protected int backtrack(int position) {
            while (position-- > 0) {
                int nextChar = this.seekBytesRef.byteAt(position) & 0xFF;
                if (nextChar++ == 255) continue;
                this.seekBytesRef.setByteAt(position, (byte)nextChar);
                this.seekBytesRef.setLength(position + 1);
                return position;
            }
            return -1;
        }
    }

    protected static enum BlockIteration {
        NEXT,
        SEEK,
        END;

    }
}

