/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValues;

class ExpressionFunctionValues
extends DoubleValues {
    final Expression expression;
    final DoubleValues[] functionValues;
    double currentValue;
    int currentDoc = -1;
    boolean computed;

    ExpressionFunctionValues(Expression expression, DoubleValues[] functionValues) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (functionValues == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.functionValues = functionValues;
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        if (this.currentDoc == doc) {
            return true;
        }
        for (DoubleValues v : this.functionValues) {
            v.advanceExact(doc);
        }
        this.currentDoc = doc;
        this.computed = false;
        return true;
    }

    @Override
    public double doubleValue() {
        if (!this.computed) {
            this.currentValue = this.expression.evaluate(this.functionValues);
            this.computed = true;
        }
        return this.currentValue;
    }
}

