/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.AbstractAnalysisFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.solr.analysis.SolrAnalyzer;

public final class TokenizerChain
extends SolrAnalyzer {
    private static final CharFilterFactory[] EMPTY_CHAR_FITLERS = new CharFilterFactory[0];
    private static final TokenFilterFactory[] EMPTY_TOKEN_FITLERS = new TokenFilterFactory[0];
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(CustomAnalyzer customAnalyzer) {
        this(customAnalyzer.getCharFilterFactories().toArray(new CharFilterFactory[0]), customAnalyzer.getTokenizerFactory(), customAnalyzer.getTokenFilterFactories().toArray(new TokenFilterFactory[0]));
        this.setPositionIncrementGap(customAnalyzer.getPositionIncrementGap(null));
        assert (customAnalyzer.getOffsetGap(null) == 1);
    }

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this(null, tokenizer, filters);
    }

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        charFilters = null == charFilters ? EMPTY_CHAR_FITLERS : charFilters;
        TokenFilterFactory[] tokenFilterFactoryArray = filters = null == filters ? EMPTY_TOKEN_FITLERS : filters;
        if (null == tokenizer) {
            throw new NullPointerException("TokenizerFactory must not be null");
        }
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    public CharFilterFactory[] getCharFilterFactories() {
        return this.charFilters;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getTokenFilterFactories() {
        return this.filters;
    }

    @Override
    public Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            Reader cs = reader;
            for (CharFilterFactory charFilter : this.charFilters) {
                cs = charFilter.create(cs);
            }
            reader = cs;
        }
        return reader;
    }

    @Override
    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            for (CharFilterFactory charFilter : this.charFilters) {
                reader = charFilter.normalize(reader);
            }
        }
        return reader;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tk;
        TokenStream ts = tk = this.tokenizer.create(this.attributeFactory(fieldName));
        for (TokenFilterFactory filter : this.filters) {
            ts = filter.create(ts);
        }
        return new Analyzer.TokenStreamComponents(tk, ts);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream result = in;
        for (TokenFilterFactory filter : this.filters) {
            result = filter.normalize(result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (AbstractAnalysisFactory abstractAnalysisFactory : this.filters) {
            sb.append(", ");
            sb.append(abstractAnalysisFactory);
        }
        sb.append(')');
        return sb.toString();
    }

    public Analyzer getMultiTermAnalyzer() {
        return new Analyzer(){

            @Override
            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tk;
                TokenStream ts = tk = new KeywordTokenizer();
                for (TokenFilterFactory filter : TokenizerChain.this.filters) {
                    ts = filter.normalize(ts);
                }
                return new Analyzer.TokenStreamComponents(tk, ts);
            }

            @Override
            protected Reader initReader(String fieldName, Reader reader) {
                if (TokenizerChain.this.charFilters != null && TokenizerChain.this.charFilters.length > 0) {
                    Reader cs = reader;
                    for (CharFilterFactory charFilter : TokenizerChain.this.charFilters) {
                        cs = charFilter.normalize(cs);
                    }
                    reader = cs;
                }
                return reader;
            }
        };
    }
}

