/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class ConfigTool
extends ToolBase {
    public ConfigTool() {
        this(CLIO.getOutStream());
    }

    public ConfigTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public List<Option> getOptions() {
        List<Option> configOptions = List.of(Option.builder((String)"action").argName("ACTION").hasArg().required(false).desc("Config API action, one of: set-property, unset-property; set-user-property, unset-user-property; default is 'set-property'.").build(), Option.builder((String)"property").argName("PROP").hasArg().required(true).desc("Name of the Config API property to apply the action to, such as: 'updateHandler.autoSoftCommit.maxTime'.").build(), Option.builder((String)"value").argName("VALUE").hasArg().required(false).desc("Set the property to this value; accepts JSON objects and strings.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_ZKHOST, Option.builder((String)"p").argName("PORT").hasArg().required(false).desc("The port of the Solr node to use when applying configuration change.").longOpt("port").build(), Option.builder((String)"s").argName("SCHEME").hasArg().required(false).desc("The scheme for accessing Solr.  Accepted values: http or https.  Default is 'http'").longOpt("scheme").build());
        return SolrCLI.joinOptions(configOptions, SolrCLI.cloudOptions);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        block14: {
            Object solrUrl;
            try {
                solrUrl = SolrCLI.resolveSolrUrl(cli);
            }
            catch (IllegalStateException e) {
                String scheme = cli.getOptionValue("scheme", "http");
                if (cli.hasOption("port")) {
                    solrUrl = scheme + "://localhost:" + cli.getOptionValue("port", "8983") + "/solr";
                }
                throw e;
            }
            String action = cli.getOptionValue("action", "set-property");
            String collection = cli.getOptionValue("collection");
            String property = cli.getOptionValue("property");
            String value = cli.getOptionValue("value");
            HashMap<String, Object> jsonObj = new HashMap<String, Object>();
            if (value != null) {
                HashMap<String, String> setMap = new HashMap<String, String>();
                setMap.put(property, value);
                jsonObj.put(action, setMap);
            } else {
                jsonObj.put(action, property);
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 0).write(jsonObj);
            String jsonBody = arr.toString();
            String updatePath = "/" + collection + "/config";
            this.echo("\nPOSTing request to Config API: " + (String)solrUrl + updatePath);
            this.echo(jsonBody);
            try (Http2SolrClient solrClient = new Http2SolrClient.Builder((String)solrUrl).build();){
                NamedList<Object> result = SolrCLI.postJsonToSolr(solrClient, updatePath, jsonBody);
                Integer statusCode = (Integer)result.findRecursive("responseHeader", "status");
                if (statusCode == 0) {
                    if (value != null) {
                        this.echo("Successfully " + action + " " + property + " to " + value);
                    } else {
                        this.echo("Successfully " + action + " " + property);
                    }
                    break block14;
                }
                throw new Exception("Failed to " + action + " property due to:\n" + result);
            }
        }
    }
}

