/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.ReplicaHealth;
import org.apache.solr.cli.ShardHealth;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthcheckTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_ZKHOST, Option.builder((String)"c").argName("COLLECTION").hasArg().required(false).desc("Name of collection; no default.").longOpt("collection").build());
    }

    public HealthcheckTool() {
        this(CLIO.getOutStream());
    }

    public HealthcheckTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        try (CloudHttp2SolrClient cloudSolrClient = new CloudHttp2SolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            cloudSolrClient.connect();
            this.runCloudTool(cloudSolrClient, cli);
        }
    }

    @Override
    public String getName() {
        return "healthcheck";
    }

    protected void runCloudTool(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String collection = cli.getOptionValue("collection");
        if (collection == null) {
            throw new IllegalArgumentException("Must provide a collection to run a healthcheck against!");
        }
        log.debug("Running healthcheck for {}", (Object)collection);
        ZkStateReader zkStateReader = ZkStateReader.from(cloudSolrClient);
        ClusterState clusterState = zkStateReader.getClusterState();
        Set<String> liveNodes = clusterState.getLiveNodes();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection == null || docCollection.getSlices() == null) {
            throw new IllegalArgumentException("Collection " + collection + " not found!");
        }
        Collection<Slice> slices = docCollection.getSlices();
        SolrQuery q = new SolrQuery("*:*");
        q.setRows(0);
        QueryResponse qr = cloudSolrClient.query(collection, q);
        SolrCLI.checkCodeForAuthError(qr.getStatus());
        String collErr = null;
        long docCount = -1L;
        try {
            docCount = qr.getResults().getNumFound();
        }
        catch (Exception exc) {
            collErr = String.valueOf(exc);
        }
        ArrayList<Map<String, Object>> shardList = new ArrayList<Map<String, Object>>();
        boolean collectionIsHealthy = docCount != -1L;
        for (Slice slice : slices) {
            String shardName = slice.getName();
            String leaderUrl = null;
            try {
                leaderUrl = zkStateReader.getLeaderUrl(collection, shardName, 1000);
            }
            catch (Exception exc) {
                log.warn("Failed to get leader for shard {} due to: {}", (Object)shardName, (Object)exc);
            }
            ArrayList<ReplicaHealth> replicaList = new ArrayList<ReplicaHealth>();
            for (Replica r : slice.getReplicas()) {
                Object replicaStatus;
                String uptime = null;
                String memory = null;
                long numDocs = -1L;
                ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps(r);
                String coreUrl = replicaCoreProps.getCoreUrl();
                boolean isLeader = coreUrl.equals(leaderUrl);
                String nodeName = replicaCoreProps.getNodeName();
                if (nodeName == null || !liveNodes.contains(nodeName)) {
                    replicaStatus = Replica.State.DOWN.toString();
                } else {
                    q = new SolrQuery("*:*");
                    q.setRows(0);
                    q.set("distrib", "false");
                    try (SolrClient solrClientForCollection = SolrCLI.getSolrClient(coreUrl);){
                        qr = solrClientForCollection.query(q);
                        numDocs = qr.getResults().getNumFound();
                        try (SolrClient solrClient = SolrCLI.getSolrClient(replicaCoreProps.getBaseUrl());){
                            NamedList<Object> systemInfo = solrClient.request(new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
                            uptime = SolrCLI.uptime((Long)systemInfo.findRecursive("jvm", "jmx", "upTimeMS"));
                            String usedMemory = (String)systemInfo.findRecursive("jvm", "memory", "used");
                            String totalMemory = (String)systemInfo.findRecursive("jvm", "memory", "total");
                            memory = usedMemory + " of " + totalMemory;
                        }
                        replicaStatus = replicaCoreProps.getState();
                    }
                    catch (Exception exc) {
                        log.error("ERROR: {} when trying to reach: {}", (Object)exc, (Object)coreUrl);
                        replicaStatus = SolrCLI.checkCommunicationError(exc) ? Replica.State.DOWN.toString() : "error: " + exc;
                    }
                }
                replicaList.add(new ReplicaHealth(shardName, r.getName(), coreUrl, (String)replicaStatus, numDocs, isLeader, uptime, memory));
            }
            ShardHealth shardHealth = new ShardHealth(shardName, replicaList);
            if (ShardState.healthy != shardHealth.getShardState()) {
                collectionIsHealthy = false;
            }
            shardList.add(shardHealth.asMap());
        }
        LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
        report.put("collection", collection);
        report.put("status", collectionIsHealthy ? "healthy" : "degraded");
        if (collErr != null) {
            report.put("error", collErr);
        }
        report.put("numDocs", docCount);
        report.put("numShards", slices.size());
        report.put("shards", shardList);
        CharArr arr = new CharArr();
        new JSONWriter(arr, 2).write(report);
        this.echo(arr.toString());
    }

    static enum ShardState {
        healthy,
        degraded,
        down,
        no_leader;

    }
}

