/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.EvaluatorException;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.util.GlobPatternUtil;

public class SelectStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private StreamContext streamContext;
    private Map<String, String> selectedFields;
    private List<String> selectedFieldGlobPatterns;
    private Map<StreamEvaluator, String> selectedEvaluators;
    private List<StreamOperation> operations;

    public SelectStream(TupleStream stream, List<String> selectedFields) throws IOException {
        this.stream = stream;
        this.selectedFields = new HashMap<String, String>();
        this.selectedFieldGlobPatterns = new ArrayList<String>();
        for (String selectedField : selectedFields) {
            if (selectedField.contains("*")) {
                this.selectedFieldGlobPatterns.add(selectedField);
                continue;
            }
            this.selectedFields.put(selectedField, selectedField);
        }
        this.operations = new ArrayList<StreamOperation>();
        this.selectedEvaluators = new LinkedHashMap<StreamEvaluator, String>();
    }

    public SelectStream(TupleStream stream, Map<String, String> selectedFields) throws IOException {
        this.stream = stream;
        this.selectedFields = selectedFields;
        this.selectedFieldGlobPatterns = new ArrayList<String>();
        this.operations = new ArrayList<StreamOperation>();
        this.selectedEvaluators = new LinkedHashMap<StreamEvaluator, String>();
    }

    public SelectStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpressionParameter> selectAsFieldsExpressions = factory.getOperandsOfType(expression, StreamExpressionValue.class);
        List<StreamExpression> operationExpressions = factory.getExpressionOperandsRepresentingTypes(expression, StreamOperation.class);
        List<StreamExpression> evaluatorExpressions = factory.getExpressionOperandsRepresentingTypes(expression, StreamEvaluator.class);
        if (expression.getParameters().size() != streamExpressions.size() + selectAsFieldsExpressions.size() + operationExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single stream but found %d (must be TupleStream types)", expression, streamExpressions.size()));
        }
        if (0 == selectAsFieldsExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one select field but found %d", expression, streamExpressions.size()));
        }
        if (0 != evaluatorExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - evaluators must be given a name, like 'add(...) as result' but found %d evaluators without names", expression, evaluatorExpressions.size()));
        }
        this.stream = factory.constructStream(streamExpressions.get(0));
        this.selectedFields = new HashMap<String, String>();
        this.selectedFieldGlobPatterns = new ArrayList<String>();
        this.selectedEvaluators = new LinkedHashMap<StreamEvaluator, String>();
        for (StreamExpressionParameter parameter : selectAsFieldsExpressions) {
            StreamExpressionValue selectField = (StreamExpressionValue)parameter;
            String value = selectField.getValue().trim();
            if (value.length() > 2 && value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.toLowerCase(Locale.ROOT).contains(" as ")) {
                String[] parts = value.split("(?i) as ");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting select field of form 'fieldA' or 'fieldA as alias' but found %s", expression, value));
                }
                String asValue = parts[0].trim();
                String asName = parts[1].trim();
                boolean handled = false;
                if (asValue.contains("(")) {
                    try {
                        StreamExpression asValueExpression = StreamExpressionParser.parse(asValue);
                        if (factory.doesRepresentTypes(asValueExpression, StreamEvaluator.class)) {
                            this.selectedEvaluators.put(factory.constructEvaluator(asValueExpression), asName);
                            handled = true;
                        }
                    }
                    catch (Throwable e) {
                        Throwable t = e;
                        do {
                            if (!(t instanceof EvaluatorException)) continue;
                            throw new IOException(t);
                        } while ((t = t.getCause()) != null);
                    }
                }
                if (handled) continue;
                this.selectedFields.put(asValue, asName);
                continue;
            }
            if (value.contains("*")) {
                this.selectedFieldGlobPatterns.add(value);
                continue;
            }
            this.selectedFields.put(value, value);
        }
        this.operations = new ArrayList<StreamOperation>();
        for (StreamExpression expr : operationExpressions) {
            this.operations.add(factory.constructOperation(expr));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.stream instanceof Expressible)) throw new IOException("This SelectStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        for (Map.Entry<String, String> entry : this.selectedFields.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) {
                expression.addParameter(entry.getKey());
                continue;
            }
            expression.addParameter(String.format(Locale.ROOT, "%s as %s", entry.getKey(), entry.getValue()));
        }
        for (String string : this.selectedFieldGlobPatterns) {
            expression.addParameter(string);
        }
        for (Map.Entry entry : this.selectedEvaluators.entrySet()) {
            expression.addParameter(String.format(Locale.ROOT, "%s as %s", ((StreamEvaluator)entry.getKey()).toExpression(factory), entry.getValue()));
        }
        for (StreamOperation streamOperation : this.operations) {
            expression.addParameter(streamOperation.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        Explanation explanation = new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
        for (StreamEvaluator evaluator : this.selectedEvaluators.keySet()) {
            explanation.addHelper(evaluator.toExplanation(factory));
        }
        for (StreamOperation operation : this.operations) {
            explanation.addHelper(operation.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        this.stream.setStreamContext(context);
        Set<StreamEvaluator> evaluators = this.selectedEvaluators.keySet();
        for (StreamEvaluator evaluator : evaluators) {
            evaluator.setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple original = this.stream.read();
        if (original.EOF) {
            return original;
        }
        Tuple workingToReturn = new Tuple();
        Tuple workingForEvaluators = new Tuple();
        this.streamContext.getTupleContext().clear();
        block0: for (String string : original.getFields().keySet()) {
            workingForEvaluators.put(string, original.get(string));
            if (this.selectedFields.containsKey(string)) {
                workingToReturn.put(this.selectedFields.get(string), original.get(string));
                continue;
            }
            for (String globPattern : this.selectedFieldGlobPatterns) {
                if (!GlobPatternUtil.matches(globPattern, string)) continue;
                workingToReturn.put(string, original.get(string));
                continue block0;
            }
        }
        for (StreamOperation streamOperation : this.operations) {
            streamOperation.operate(workingToReturn);
            streamOperation.operate(workingForEvaluators);
        }
        for (Map.Entry entry : this.selectedEvaluators.entrySet()) {
            Object o = ((StreamEvaluator)entry.getKey()).evaluate(workingForEvaluators);
            if (o == null) continue;
            workingForEvaluators.put((String)entry.getValue(), o);
            workingToReturn.put((String)entry.getValue(), o);
        }
        return workingToReturn;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort().copyAliased(this.selectedFields);
    }

    @Override
    public int getCost() {
        return 0;
    }
}

