/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.jayway.jsonpath.internal.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetCmds {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_CONFIGSET = "baseConfigSet";
    public static final String CONFIG_SET_PROPERTY_PREFIX = "configSetProp.";

    public static String getBaseConfigSetName(ConfigSetParams.ConfigSetAction action, String baseConfigSetName) {
        if (action == ConfigSetParams.ConfigSetAction.CREATE) {
            return Utils.isEmpty((CharSequence)baseConfigSetName) ? "_default" : baseConfigSetName;
        }
        return null;
    }

    private static NamedList<Object> getConfigSetProperties(ConfigSetService configSetService, String configName, String propertyPath) throws IOException {
        byte[] oldPropsData = configSetService.downloadFileFromConfig(configName, propertyPath);
        if (oldPropsData != null) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(oldPropsData), StandardCharsets.UTF_8);){
                NamedList<Object> namedList = ConfigSetProperties.readFromInputStream(reader);
                return namedList;
            }
        }
        return null;
    }

    private static Map<String, Object> getNewProperties(ZkNodeProps message) {
        HashMap<String, Object> properties = null;
        for (Map.Entry<String, Object> entry : message.getProperties().entrySet()) {
            if (!entry.getKey().startsWith(CONFIG_SET_PROPERTY_PREFIX)) continue;
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            properties.put(entry.getKey().substring(CONFIG_SET_PROPERTY_PREFIX.length()), entry.getValue());
        }
        return properties;
    }

    private static void mergeOldProperties(Map<String, Object> newProps, NamedList<Object> oldProps) {
        for (Map.Entry<String, Object> entry : oldProps) {
            if (newProps.containsKey(entry.getKey())) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
    }

    private static byte[] getPropertyData(Map<String, Object> newProps) {
        if (newProps != null) {
            String propertyDataStr = org.apache.solr.common.util.Utils.toJSONString(newProps);
            if (propertyDataStr == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid property specification");
            }
            return propertyDataStr.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    public static void createConfigSet(ZkNodeProps message, CoreContainer coreContainer) throws IOException {
        NamedList<Object> oldProps;
        String configSetName = message.getStr("name");
        if (configSetName == null || configSetName.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
        }
        String baseConfigSetName = message.getStr(BASE_CONFIGSET, "_default");
        if (coreContainer.getConfigSetService().checkConfigExists(configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + configSetName);
        }
        if (!coreContainer.getConfigSetService().checkConfigExists(baseConfigSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + baseConfigSetName);
        }
        String propertyPath = "configsetprops.json";
        Map<String, Object> props = ConfigSetCmds.getNewProperties(message);
        if (props != null && (oldProps = ConfigSetCmds.getConfigSetProperties(coreContainer.getConfigSetService(), baseConfigSetName, propertyPath)) != null) {
            ConfigSetCmds.mergeOldProperties(props, oldProps);
        }
        byte[] propertyData = ConfigSetCmds.getPropertyData(props);
        try {
            coreContainer.getConfigSetService().copyConfig(baseConfigSetName, configSetName);
            if (propertyData != null) {
                coreContainer.getConfigSetService().uploadFileToConfig(configSetName, propertyPath, propertyData, true);
            }
        }
        catch (Exception e) {
            try {
                if (coreContainer.getConfigSetService().checkConfigExists(configSetName)) {
                    ConfigSetCmds.deleteConfigSet(configSetName, true, coreContainer);
                }
            }
            catch (IOException ioe) {
                log.error("Error while trying to delete partially created ConfigSet", (Throwable)ioe);
            }
            throw e;
        }
    }

    public static void deleteConfigSet(ZkNodeProps message, CoreContainer coreContainer) throws IOException {
        String configSetName = message.getStr("name");
        if (configSetName == null || configSetName.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
        }
        ConfigSetCmds.deleteConfigSet(configSetName, false, coreContainer);
    }

    private static void deleteConfigSet(String configSetName, boolean force, CoreContainer coreContainer) throws IOException {
        ZkStateReader zkStateReader = coreContainer.getZkController().getZkStateReader();
        for (Map.Entry<String, DocCollection> entry : zkStateReader.getClusterState().getCollectionsMap().entrySet()) {
            String configName = entry.getValue().getConfigName();
            if (!configSetName.equals(configName)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not delete ConfigSet as it is currently being used by collection [" + entry.getKey() + "]");
        }
        String propertyPath = "configsetprops.json";
        NamedList<Object> properties = ConfigSetCmds.getConfigSetProperties(coreContainer.getConfigSetService(), configSetName, propertyPath);
        if (properties != null) {
            boolean isImmutableConfigSet;
            Object immutable = properties.get("immutable");
            boolean bl = isImmutableConfigSet = immutable != null ? Boolean.parseBoolean(immutable.toString()) : false;
            if (!force && isImmutableConfigSet) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Requested delete of immutable ConfigSet: " + configSetName);
            }
        }
        coreContainer.getConfigSetService().deleteConfig(configSetName);
    }
}

