/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMap {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final String dir;
    protected SolrZkClient zookeeper;
    protected static final String PREFIX = "mn-";

    public DistributedMap(SolrZkClient zookeeper, String dir) {
        this.dir = dir;
        try {
            ZkMaintenanceUtils.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.zookeeper = zookeeper;
    }

    private void assertKeyFormat(String trackingId) {
        if (trackingId == null || trackingId.length() == 0 || trackingId.contains("/")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported key format: " + trackingId);
        }
    }

    public void put(String trackingId, byte[] data) throws KeeperException, InterruptedException {
        this.assertKeyFormat(trackingId);
        this.zookeeper.makePath(this.dir + "/mn-" + trackingId, data, CreateMode.PERSISTENT, null, false, true);
    }

    public boolean putIfAbsent(String trackingId, byte[] data) throws KeeperException, InterruptedException {
        this.assertKeyFormat(trackingId);
        try {
            this.zookeeper.makePath(this.dir + "/mn-" + trackingId, data, CreateMode.PERSISTENT, null, true, true);
            return true;
        }
        catch (KeeperException.NodeExistsException e) {
            return false;
        }
    }

    public byte[] get(String trackingId) throws KeeperException, InterruptedException {
        return this.zookeeper.getData(this.dir + "/mn-" + trackingId, null, null, true);
    }

    public boolean contains(String trackingId) throws KeeperException, InterruptedException {
        return this.zookeeper.exists(this.dir + "/mn-" + trackingId, true);
    }

    public int size() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zookeeper.getData(this.dir, null, stat, true);
        return stat.getNumChildren();
    }

    public boolean remove(String trackingId) throws KeeperException, InterruptedException {
        String path = this.dir + "/mn-" + trackingId;
        try {
            this.zookeeper.delete(path, -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (KeeperException.NotEmptyException hack) {
            log.warn("Cleaning malformed key ID starting with {}", (Object)path);
            this.zookeeper.clean(path);
        }
        return true;
    }

    public void clear() throws KeeperException, InterruptedException {
        List<String> childNames = this.zookeeper.getChildren(this.dir, null, true);
        for (String childName : childNames) {
            this.zookeeper.delete(this.dir + "/" + childName, -1, true);
        }
    }

    public Collection<String> keys() throws KeeperException, InterruptedException {
        List<String> childs = this.zookeeper.getChildren(this.dir, null, true);
        ArrayList<String> ids = new ArrayList<String>(childs.size());
        childs.stream().forEach(child -> ids.add(child.substring(PREFIX.length())));
        return ids;
    }
}

