/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.Stats;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerTaskProcessor
implements Runnable,
Closeable {
    public static final int MAX_PARALLEL_TASKS = 100;
    public static final int MAX_BLOCKED_TASKS = 1000;
    public ExecutorService tpe;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OverseerTaskQueue workQueue;
    private DistributedMap runningMap;
    private DistributedMap completedMap;
    private DistributedMap failureMap;
    private final Set<String> runningTasks;
    private final ConcurrentHashMap<String, OverseerTaskQueue.QueueEvent> completedTasks;
    private volatile String myId;
    private volatile ZkStateReader zkStateReader;
    private boolean isClosed;
    private volatile Stats stats;
    private SolrMetricsContext overseerTaskProcessorMetricsContext;
    private final Set<String> runningZKTasks;
    private final Map<String, OverseerTaskQueue.QueueEvent> blockedTasks = Collections.synchronizedMap(new LinkedHashMap());
    private final Predicate<String> excludedTasks = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return OverseerTaskProcessor.this.runningTasks.contains(s) || OverseerTaskProcessor.this.blockedTasks.containsKey(s);
        }

        public String toString() {
            return StrUtils.join(Set.of(OverseerTaskProcessor.this.runningTasks, OverseerTaskProcessor.this.blockedTasks.keySet()), ',');
        }
    };
    private final Object waitLock = new Object();
    protected OverseerMessageHandlerSelector selector;
    private OverseerNodePrioritizer prioritizer;
    private String thisNode;

    public OverseerTaskProcessor(ZkStateReader zkStateReader, String myId, Stats stats, OverseerMessageHandlerSelector selector, OverseerNodePrioritizer prioritizer, OverseerTaskQueue workQueue, DistributedMap runningMap, DistributedMap completedMap, DistributedMap failureMap, SolrMetricsContext solrMetricsContext) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.stats = stats;
        this.selector = selector;
        this.prioritizer = prioritizer;
        this.workQueue = workQueue;
        this.runningMap = runningMap;
        this.completedMap = completedMap;
        this.failureMap = failureMap;
        this.runningZKTasks = ConcurrentHashMap.newKeySet();
        this.runningTasks = ConcurrentHashMap.newKeySet();
        this.completedTasks = new ConcurrentHashMap();
        this.thisNode = MDCLoggingContext.getNodeName();
        this.overseerTaskProcessorMetricsContext = solrMetricsContext.getChildContext(this);
        this.overseerTaskProcessorMetricsContext.gauge(() -> workQueue.getZkStats().getQueueLength(), true, "collectionWorkQueueSize", "queue");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanUpWorkQueue() throws KeeperException, InterruptedException {
        Iterator<Map.Entry<String, OverseerTaskQueue.QueueEvent>> it = this.completedTasks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, OverseerTaskQueue.QueueEvent> entry = it.next();
            this.workQueue.remove(entry.getValue());
            this.runningZKTasks.remove(entry.getKey());
            it.remove();
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.overseerTaskProcessorMetricsContext.unregister();
        if (this.tpe != null && !ExecutorUtil.isShutdown(this.tpe)) {
            ExecutorUtil.shutdownAndAwaitTermination(this.tpe);
        }
        IOUtils.closeQuietly(this.selector);
    }

    public static List<String> getSortedOverseerNodeNames(SolrZkClient zk) throws KeeperException, InterruptedException {
        List<String> children = null;
        try {
            children = zk.getChildren("/overseer_elect/election", null, true);
        }
        catch (Exception e) {
            log.warn("error ", (Throwable)e);
            return new ArrayList<String>();
        }
        LeaderElector.sortSeqs(children);
        ArrayList<String> nodeNames = new ArrayList<String>(children.size());
        for (String c : children) {
            nodeNames.add(LeaderElector.getNodeName(c));
        }
        return nodeNames;
    }

    public static List<String> getSortedElectionNodes(SolrZkClient zk, String path) throws KeeperException, InterruptedException {
        List<String> children = null;
        children = zk.getChildren(path, null, true);
        LeaderElector.sortSeqs(children);
        return children;
    }

    public static String getLeaderNode(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        String id = OverseerTaskProcessor.getLeaderId(zkClient);
        return id == null ? null : LeaderElector.getNodeName(id);
    }

    public static String getLeaderId(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        byte[] data = null;
        try {
            data = zkClient.getData("/overseer_elect/leader", null, new Stat(), true);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        Map m = (Map)Utils.fromJSON(data);
        return (String)m.get("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Overseer.LeaderStatus amILeader() {
        String statsName = "collection_am_i_leader";
        Timer.Context timerContext = this.stats.time(statsName);
        boolean success = true;
        String propsId = null;
        try {
            ZkNodeProps props = ZkNodeProps.load(this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            propsId = props.getStr("id");
            if (this.myId.equals(propsId)) {
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.YES;
                return leaderStatus;
            }
        }
        catch (KeeperException e) {
            success = false;
            if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                log.error("", (Throwable)e);
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.DONT_KNOW;
                return leaderStatus;
            }
            if (e.code() != KeeperException.Code.SESSIONEXPIRED) {
                log.warn("", (Throwable)e);
            } else {
                log.debug("", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            success = false;
            Thread.currentThread().interrupt();
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success(statsName);
            } else {
                this.stats.error(statsName);
            }
        }
        log.info("According to ZK I (id={}) am no longer a leader. propsId={}", (Object)this.myId, (Object)propsId);
        return Overseer.LeaderStatus.NO;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void markTaskAsRunning(OverseerTaskQueue.QueueEvent head, String asyncId) throws KeeperException, InterruptedException {
        this.runningZKTasks.add(head.getId());
        this.runningTasks.add(head.getId());
        if (asyncId != null) {
            this.runningMap.put(asyncId, null);
        }
    }

    private void printTrackingMaps() {
        if (log.isDebugEnabled()) {
            log.debug("RunningTasks: {}", this.runningTasks);
            log.debug("BlockedTasks: {}", this.blockedTasks.keySet());
            log.debug("CompletedTasks: {}", (Object)this.completedTasks.keySet());
            log.debug("RunningZKTasks: {}", this.runningZKTasks);
        }
    }

    String getId() {
        return this.myId;
    }

    public static interface OverseerMessageHandlerSelector
    extends Closeable {
        public OverseerMessageHandler selectOverseerMessageHandler(ZkNodeProps var1);
    }

    protected class Runner
    implements Runnable {
        ZkNodeProps message;
        String operation;
        OverseerSolrResponse response;
        OverseerTaskQueue.QueueEvent head;
        OverseerMessageHandler messageHandler;
        private final OverseerMessageHandler.Lock lock;

        public Runner(OverseerMessageHandler messageHandler, ZkNodeProps message, String operation, OverseerTaskQueue.QueueEvent head, OverseerMessageHandler.Lock lock) {
            this.message = message;
            this.operation = operation;
            this.head = head;
            this.messageHandler = messageHandler;
            this.lock = lock;
            this.response = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String statsName = this.messageHandler.getTimerName(this.operation);
            Timer.Context timerContext = OverseerTaskProcessor.this.stats.time(statsName);
            boolean success = false;
            String asyncId = this.message.getStr("async");
            String taskKey = this.messageHandler.getTaskKey(this.message);
            try {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Runner processing {}", (Object)this.head.getId());
                    }
                    this.response = this.messageHandler.processMessage(this.message, this.operation);
                }
                finally {
                    timerContext.stop();
                    this.updateStats(statsName);
                }
                if (asyncId != null) {
                    if (this.response != null && (this.response.getResponse().get("failure") != null || this.response.getResponse().get("exception") != null)) {
                        OverseerTaskProcessor.this.failureMap.put(asyncId, OverseerSolrResponseSerializer.serialize(this.response));
                        if (log.isDebugEnabled()) {
                            log.debug("Updated failed map for task with zkid:[{}]", (Object)this.head.getId());
                        }
                    } else {
                        OverseerTaskProcessor.this.completedMap.put(asyncId, OverseerSolrResponseSerializer.serialize(this.response));
                        if (log.isDebugEnabled()) {
                            log.debug("Updated completed map for task with zkid:[{}]", (Object)this.head.getId());
                        }
                    }
                } else {
                    this.head.setBytes(OverseerSolrResponseSerializer.serialize(this.response));
                    if (log.isDebugEnabled()) {
                        log.debug("Completed task:[{}]", (Object)this.head.getId());
                    }
                }
                this.markTaskComplete(this.head.getId(), asyncId);
                if (log.isDebugEnabled()) {
                    log.debug("Marked task [{}] as completed.", (Object)this.head.getId());
                }
                OverseerTaskProcessor.this.printTrackingMaps();
                if (log.isDebugEnabled()) {
                    log.debug("{}: Message id: {} complete, response: {}", new Object[]{this.messageHandler.getName(), this.head.getId(), this.response.getResponse()});
                }
                success = true;
            }
            catch (AlreadyClosedException alreadyClosedException) {
                this.lock.unlock();
                if (!success) {
                    try {
                        this.resetTaskWithException(this.messageHandler, this.head.getId(), asyncId, taskKey, this.message);
                    }
                    catch (AlreadyClosedException alreadyClosedException2) {
                        // empty catch block
                    }
                }
                Object object = OverseerTaskProcessor.this.waitLock;
                synchronized (object) {
                    OverseerTaskProcessor.this.waitLock.notifyAll();
                }
            }
            catch (KeeperException e) {
                log.error("KeeperException", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.resetTaskWithException(this.messageHandler, this.head.getId(), asyncId, taskKey, this.message);
                log.warn("Resetting task {} as the thread was interrupted.", (Object)this.head.getId());
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
                if (!success) {
                    try {
                        this.resetTaskWithException(this.messageHandler, this.head.getId(), asyncId, taskKey, this.message);
                    }
                    catch (AlreadyClosedException e) {}
                }
                Object e = OverseerTaskProcessor.this.waitLock;
                synchronized (e) {
                    OverseerTaskProcessor.this.waitLock.notifyAll();
                }
            }
        }

        private void markTaskComplete(String id, String asyncId) throws KeeperException, InterruptedException {
            OverseerTaskProcessor.this.completedTasks.put(id, this.head);
            OverseerTaskProcessor.this.runningTasks.remove(id);
            if (asyncId != null && !OverseerTaskProcessor.this.runningMap.remove(asyncId)) {
                log.warn("Could not find and remove async call [{}] from the running map.", (Object)asyncId);
            }
            OverseerTaskProcessor.this.workQueue.remove(this.head);
        }

        private void resetTaskWithException(OverseerMessageHandler messageHandler, String id, String asyncId, String taskKey, ZkNodeProps message) {
            log.warn("Resetting task: {}, requestid: {}, taskKey: {}", new Object[]{id, asyncId, taskKey});
            try {
                if (asyncId != null && !OverseerTaskProcessor.this.runningMap.remove(asyncId)) {
                    log.warn("Could not find and remove async call [{}] from the running map.", (Object)asyncId);
                }
                OverseerTaskProcessor.this.runningTasks.remove(id);
            }
            catch (KeeperException e) {
                log.error("KeeperException", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void updateStats(String statsName) {
            if (this.isSuccessful()) {
                OverseerTaskProcessor.this.stats.success(statsName);
            } else {
                OverseerTaskProcessor.this.stats.error(statsName);
                OverseerTaskProcessor.this.stats.storeFailureDetails(statsName, this.message, this.response);
            }
        }

        private boolean isSuccessful() {
            if (this.response == null) {
                return false;
            }
            return this.response.getResponse().get("failure") == null && this.response.getResponse().get("exception") == null;
        }
    }
}

