/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.ReplicaMigrationUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;

public class BalanceReplicasCmd
implements CollApiCmds.CollectionApiCommand {
    private final CollectionCommandContext ccc;

    public BalanceReplicasCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        Set<Object> nodes;
        Object nodesRaw = message.get("nodes");
        if (nodesRaw == null) {
            nodes = Collections.emptySet();
        } else if (nodesRaw instanceof Set) {
            nodes = (HashSet)nodesRaw;
        } else if (nodesRaw instanceof Collection) {
            nodes = new HashSet((Collection)nodesRaw);
        } else if (nodesRaw instanceof String) {
            nodes = Set.of(((String)nodesRaw).split(","));
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'nodes' was not passed as a correct type (Set/List/String): " + nodesRaw.getClass().getName());
        }
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", 600);
        boolean parallel = message.getBool("parallel", false);
        if (nodes.size() == 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot balance across a single node: " + (String)nodes.stream().findAny().get());
        }
        Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
        Map<Replica, String> replicaMovements = assignStrategy.computeReplicaBalancing(this.ccc.getSolrCloudManager(), nodes, message.getInt("maxBalanceSkew", -1));
        boolean migrationSuccessful = ReplicaMigrationUtils.migrateReplicas(this.ccc, replicaMovements, parallel, waitForFinalState, timeout, async, results);
        if (migrationSuccessful) {
            results.add("success", "BalanceReplicas action completed successfully across nodes  : [" + String.join((CharSequence)", ", nodes) + "]");
        }
    }
}

