/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnapshotCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public CreateSnapshotCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String extCollectionName = message.getStr("collection");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ccc.getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName) : extCollectionName;
        String commitName = message.getStr("commitName");
        String asyncId = message.getStr("async");
        SolrZkClient zkClient = this.ccc.getZkStateReader().getZkClient();
        Date creationDate = new Date();
        if (SolrSnapshotManager.snapshotExists(zkClient, collectionName, commitName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " already exists for collection " + collectionName);
        }
        log.info("Creating a snapshot for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        SolrSnapshotManager.createCollectionLevelSnapshot(zkClient, collectionName, new CollectionSnapshotMetaData(commitName));
        log.info("Created a ZK path to store snapshot information for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        NamedList<Object> shardRequestResults = new NamedList<Object>();
        HashMap<String, Slice> shardByCoreName = new HashMap<String, Slice>();
        ShardHandler shardHandler = this.ccc.newShardHandler();
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        for (Slice slice : this.ccc.getZkStateReader().getClusterState().getCollection(collectionName).getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                if (replica.getState() != Replica.State.ACTIVE) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("Replica {} is not active. Hence not sending the createsnapshot request", (Object)replica.getCoreName());
                    continue;
                }
                String coreName = replica.getStr("core");
                ModifiableSolrParams modifiableSolrParams = new ModifiableSolrParams();
                modifiableSolrParams.set("action", CoreAdminParams.CoreAdminAction.CREATESNAPSHOT.toString());
                modifiableSolrParams.set("name", slice.getName());
                modifiableSolrParams.set("core", coreName);
                modifiableSolrParams.set("commitName", commitName);
                shardRequestTracker.sendShardRequest(replica.getNodeName(), modifiableSolrParams, shardHandler);
                log.debug("Sent createsnapshot request to core={} with commitName={}", (Object)coreName, (Object)commitName);
                shardByCoreName.put(coreName, slice);
            }
        }
        HashSet<String> failedShards = new HashSet<String>();
        shardRequestTracker.processResponses(shardRequestResults, shardHandler, false, null);
        NamedList success = (NamedList)shardRequestResults.get("success");
        ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData> replicas = new ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData>();
        if (success != null) {
            for (int i = 0; i < success.size(); ++i) {
                NamedList resp = (NamedList)success.getVal(i);
                String string = (String)resp.get("core");
                Slice slice = (Slice)shardByCoreName.remove(string);
                boolean leader = slice.getLeader() != null && slice.getLeader().getCoreName().equals(string);
                resp.add("shard_id", slice.getName());
                resp.add("leader", leader);
                CollectionSnapshotMetaData.CoreSnapshotMetaData c = new CollectionSnapshotMetaData.CoreSnapshotMetaData(resp);
                replicas.add(c);
                if (!log.isInfoEnabled()) continue;
                log.info("Snapshot with commitName {} is created successfully for core {}", (Object)commitName, (Object)c.getCoreName());
            }
        }
        if (!shardByCoreName.isEmpty()) {
            log.warn("Unable to create a snapshot with name {} for following cores {}", (Object)commitName, shardByCoreName.keySet());
            HashMap<String, Integer> failuresByShardId = new HashMap<String, Integer>();
            for (Map.Entry entry : shardByCoreName.entrySet()) {
                int f = 0;
                if (failuresByShardId.get(((Slice)entry.getValue()).getName()) != null) {
                    f = (Integer)failuresByShardId.get(((Slice)entry.getValue()).getName());
                }
                failuresByShardId.put(((Slice)entry.getValue()).getName(), f + 1);
            }
            DocCollection collectionStatus = this.ccc.getZkStateReader().getClusterState().getCollection(collectionName);
            for (Map.Entry entry : failuresByShardId.entrySet()) {
                int replicaCount = collectionStatus.getSlice((String)entry.getKey()).getReplicas().size();
                if (replicaCount > (Integer)entry.getValue()) continue;
                failedShards.add((String)entry.getKey());
            }
        }
        if (failedShards.isEmpty()) {
            CollectionSnapshotMetaData meta = new CollectionSnapshotMetaData(commitName, CollectionSnapshotMetaData.SnapshotStatus.Successful, creationDate, replicas);
            SolrSnapshotManager.updateCollectionLevelSnapshot(zkClient, collectionName, meta);
            if (log.isInfoEnabled()) {
                log.info("Saved following snapshot information for collection={} with commitName={} in Zookeeper : {}", new Object[]{collectionName, commitName, meta.toNamedList()});
            }
        } else {
            log.warn("Failed to create a snapshot for collection {} with commitName = {}. Snapshot could not be captured for following shards {}", new Object[]{collectionName, commitName, failedShards});
            CollectionSnapshotMetaData meta = new CollectionSnapshotMetaData(commitName, CollectionSnapshotMetaData.SnapshotStatus.Failed, creationDate, replicas);
            SolrSnapshotManager.updateCollectionLevelSnapshot(zkClient, collectionName, meta);
            if (log.isInfoEnabled()) {
                log.info("Saved following snapshot information for collection={} with commitName={} in Zookeeper : {}", new Object[]{collectionName, commitName, meta.toNamedList()});
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create snapshot on shards " + failedShards);
        }
    }
}

