/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.ReplicaMigrationUtils;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;

public class DeleteNodeCmd
implements CollApiCmds.CollectionApiCommand {
    private final CollectionCommandContext ccc;

    public DeleteNodeCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        CollectionHandlingUtils.checkRequired(message, "node");
        String node = message.getStr("node");
        List<Replica> sourceReplicas = ReplicaMigrationUtils.getReplicasOfNode(node, state);
        List<String> singleReplicas = DeleteNodeCmd.verifyReplicaAvailability(sourceReplicas, state);
        if (!singleReplicas.isEmpty()) {
            results.add("failure", "Can't delete the only existing non-PULL replica(s) on node " + node + ": " + singleReplicas);
        } else {
            ReplicaMigrationUtils.cleanupReplicas(results, state, sourceReplicas, this.ccc, message.getStr("async"));
        }
    }

    static List<String> verifyReplicaAvailability(List<Replica> sourceReplicas, ClusterState state) {
        ArrayList<String> res = new ArrayList<String>();
        for (Replica sourceReplica : sourceReplicas) {
            String coll = sourceReplica.getCollection();
            String shard = sourceReplica.getShard();
            String replicaName = sourceReplica.getName();
            DocCollection collection = state.getCollection(coll);
            Slice slice = collection.getSlice(shard);
            if (slice.getReplicas().size() < 2) {
                res.add(coll + "/" + shard + "/" + replicaName + ", type=" + sourceReplica.getType());
                continue;
            }
            int otherNonPullReplicas = 0;
            for (Replica r : slice.getReplicas()) {
                if (r.getName().equals(replicaName) || r.getType().equals((Object)Replica.Type.PULL)) continue;
                ++otherNonPullReplicas;
            }
            if (otherNonPullReplicas != 0) continue;
            res.add(coll + "/" + shard + "/" + replicaName + ", type=" + sourceReplica.getType());
        }
        return res;
    }
}

