/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReplicaCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public DeleteReplicaCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        this.deleteReplica(clusterState, message, results, null);
    }

    void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results, Runnable onComplete) throws KeeperException, IOException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("deleteReplica() : {}", (Object)Utils.toJSONString(message));
        }
        boolean parallel = message.getBool("parallel", false);
        if (message.getStr("count") != null) {
            this.deleteReplicaBasedOnCount(clusterState, message, results, onComplete, parallel);
            return;
        }
        CollectionHandlingUtils.checkRequired(message, "collection", "shard", "replica");
        String extCollectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        String replicaName = message.getStr("replica");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = coll.getSlice(shard);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        this.deleteCore(coll, shard, replicaName, message, results, onComplete, parallel, true);
    }

    void deleteReplicaBasedOnCount(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results, Runnable onComplete, boolean parallel) throws KeeperException, IOException, InterruptedException {
        String shardId;
        Slice shardSlice;
        CollectionHandlingUtils.checkRequired(message, "collection", "count");
        int count = Integer.parseInt(message.getStr("count"));
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = null;
        if (shard != null && (slice = coll.getSlice(shard)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        HashMap<Slice, Set<String>> shardToReplicasMapping = new HashMap<Slice, Set<String>>();
        if (slice != null) {
            Set<String> replicasToBeDeleted = this.pickReplicasTobeDeleted(slice, shard, collectionName, count);
            shardToReplicasMapping.put(slice, replicasToBeDeleted);
        } else {
            Collection<Slice> allSlices = coll.getSlices();
            for (Slice slice2 : allSlices) {
                Set<String> replicasToBeDeleted = this.pickReplicasTobeDeleted(slice2, slice2.getName(), collectionName, count);
                shardToReplicasMapping.put(slice2, replicasToBeDeleted);
            }
        }
        Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
        for (Map.Entry entry : shardToReplicasMapping.entrySet()) {
            shardSlice = (Slice)entry.getKey();
            shardId = shardSlice.getName();
            Set replicaNames = (Set)entry.getValue();
            Set<Replica> replicas = replicaNames.stream().map(name -> shardSlice.getReplica((String)name)).collect(Collectors.toSet());
            assignStrategy.verifyDeleteReplicas(this.ccc.getSolrCloudManager(), coll, shardId, replicas);
        }
        for (Map.Entry entry : shardToReplicasMapping.entrySet()) {
            shardSlice = (Slice)entry.getKey();
            shardId = shardSlice.getName();
            Set replicas = (Set)entry.getValue();
            for (String replica : replicas) {
                log.debug("Deleting replica {}  for shard {} based on count {}", new Object[]{replica, shardId, count});
                this.deleteCore(coll, shardId, replica, message, results, onComplete, parallel, false);
            }
            results.add("shard_id", shardId);
            results.add("replicas_deleted", replicas);
        }
    }

    private Set<String> pickReplicasTobeDeleted(Slice slice, String shard, String collectionName, int count) {
        this.validateReplicaAvailability(slice, shard, collectionName, count);
        Collection<Replica> allReplicas = slice.getReplicas();
        HashSet<String> replicasToBeRemoved = new HashSet<String>();
        Replica leader = slice.getLeader();
        for (Replica replica : allReplicas) {
            if (count == 0) break;
            if (leader.getCoreName().equals(replica.getCoreName())) continue;
            replicasToBeRemoved.add(replica.getName());
            --count;
        }
        return replicasToBeRemoved;
    }

    private void validateReplicaAvailability(Slice slice, String shard, String collectionName, int count) {
        if (slice != null) {
            Collection<Replica> allReplicasForShard = slice.getReplicas();
            if (allReplicasForShard == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No replicas found  in shard/collection: " + shard + "/" + collectionName);
            }
            if (allReplicasForShard.size() == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There is only one replica available in shard/collection: " + shard + "/" + collectionName + ". Cannot delete that.");
            }
            if (allReplicasForShard.size() <= count) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There are lesser num replicas requested to be deleted than are available in shard/collection : " + shard + "/" + collectionName + " Requested: " + count + " Available: " + allReplicasForShard.size() + ".");
            }
        }
    }

    void deleteCore(DocCollection coll, String shardId, String replicaName, ZkNodeProps message, NamedList<Object> results, Runnable onComplete, boolean parallel, boolean verifyPlacement) throws KeeperException, IOException, InterruptedException {
        block10: {
            Slice slice = coll.getSlice(shardId);
            Replica replica = slice.getReplica(replicaName);
            if (replica == null) {
                ArrayList<String> l = new ArrayList<String>();
                for (Replica r : slice.getReplicas()) {
                    l.add(r.getName());
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid replica : " + replicaName + " in shard/collection : " + shardId + "/" + coll.getName() + " available replicas are " + StrUtils.join(l, ','));
            }
            if (Boolean.parseBoolean(message.getStr("onlyIfDown")) && replica.getState() != Replica.State.DOWN) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Attempted to remove replica : " + coll.getName() + "/" + shardId + "/" + replicaName + " with onlyIfDown='true', but state is '" + replica.getStr("state") + "'");
            }
            if (verifyPlacement) {
                Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
                assignStrategy.verifyDeleteReplicas(this.ccc.getSolrCloudManager(), coll, shardId, Set.of(replica));
            }
            ShardHandler shardHandler = this.ccc.newShardHandler();
            String core = replica.getStr("core");
            String asyncId = message.getStr("async");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.add("core", core);
            params.set("deleteIndex", message.getBool("deleteIndex", true));
            params.set("deleteInstanceDir", message.getBool("deleteInstanceDir", true));
            params.set("deleteDataDir", message.getBool("deleteDataDir", true));
            boolean isLive = this.ccc.getZkStateReader().getClusterState().getLiveNodes().contains(replica.getNodeName());
            CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
            if (isLive) {
                shardRequestTracker.sendShardRequest(replica.getNodeName(), params, shardHandler);
            }
            Callable<Boolean> callable = () -> {
                try {
                    if (isLive) {
                        shardRequestTracker.processResponses(results, shardHandler, false, null);
                        if (CollectionHandlingUtils.waitForCoreNodeGone(coll.getName(), shardId, replicaName, 30000, this.ccc.getZkStateReader())) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                    }
                    CollectionHandlingUtils.deleteCoreNode(coll.getName(), replicaName, replica, core, this.ccc);
                    if (CollectionHandlingUtils.waitForCoreNodeGone(coll.getName(), shardId, replicaName, 30000, this.ccc.getZkStateReader())) {
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                catch (Exception e) {
                    results.add("failure", "Could not complete delete " + e.getMessage());
                    throw e;
                }
                finally {
                    if (onComplete != null) {
                        onComplete.run();
                    }
                }
            };
            if (!parallel) {
                try {
                    if (!callable.call().booleanValue()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not remove replica : " + coll.getName() + "/" + shardId + "/" + replicaName);
                    }
                    break block10;
                }
                catch (InterruptedException | KeeperException e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Error waiting for corenode gone", (Throwable)ex);
                }
            }
            this.ccc.getExecutorService().submit(callable);
        }
    }
}

