/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.zookeeper.common.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallShardDataCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public InstallShardDataCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        RemoteMessage typedMessage = (RemoteMessage)new ObjectMapper().convertValue(message.getProperties(), RemoteMessage.class);
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(typedMessage.asyncId, this.ccc);
        ClusterState clusterState = this.ccc.getZkStateReader().getClusterState();
        typedMessage.validate();
        DocCollection installCollection = clusterState.getCollection(typedMessage.collection);
        Slice installSlice = installCollection.getSlice(typedMessage.shard);
        if (installSlice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The specified shard [" + typedMessage.shard + "] does not exist.");
        }
        ModifiableSolrParams coreApiParams = new ModifiableSolrParams();
        coreApiParams.set("action", CoreAdminParams.CoreAdminAction.INSTALLCOREDATA.toString());
        typedMessage.toMap(new HashMap<String, Object>()).forEach((k, v) -> coreApiParams.set((String)k, v.toString()));
        ShardHandler shardHandler = this.ccc.newShardHandler();
        shardRequestTracker.sliceCmd(clusterState, coreApiParams, null, installSlice, shardHandler);
        String errorMessage = String.format(Locale.ROOT, "Could not install data to collection [%s] and shard [%s]", typedMessage.collection, typedMessage.shard);
        shardRequestTracker.processResponses(results, shardHandler, true, errorMessage);
    }

    public static class RemoteMessage
    implements JacksonReflectMapWriter {
        @JsonProperty(value="operation")
        public String operation = CollectionParams.CollectionAction.INSTALLSHARDDATA.toLower();
        @JsonProperty
        public String collection;
        @JsonProperty
        public String shard;
        @JsonProperty
        public String repository;
        @JsonProperty
        public String location;
        @JsonProperty(value="async")
        public String asyncId;

        public void validate() {
            if (StringUtils.isBlank((String)this.collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'Install Shard Data' API requires a valid collection name to be provided");
            }
            if (StringUtils.isBlank((String)this.shard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'Install Shard Data' API requires a valid shard name to be provided");
            }
        }
    }
}

