/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.ReplicaMigrationUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.NamedList;

public class MigrateReplicasCmd
implements CollApiCmds.CollectionApiCommand {
    private final CollectionCommandContext ccc;

    public MigrateReplicasCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        boolean migrationSuccessful;
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        Set<String> sourceNodes = this.getNodesFromParam(message, "sourceNodes");
        Set<String> targetNodes = this.getNodesFromParam(message, "targetNodes");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        if (sourceNodes.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNodes is a required param");
        }
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", 600);
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        for (String sourceNode : sourceNodes) {
            if (clusterState.liveNodesContain(sourceNode)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + sourceNode + " is not live");
        }
        for (String targetNode : targetNodes) {
            if (clusterState.liveNodesContain(targetNode)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target Node: " + targetNode + " is not live");
        }
        if (targetNodes.isEmpty() && (targetNodes = clusterState.getLiveNodes().stream().filter(n -> !sourceNodes.contains(n)).collect(Collectors.toSet())).isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No nodes other than the source nodes are live, therefore replicas cannot be migrated");
        }
        List<Replica> sourceReplicas = ReplicaMigrationUtils.getReplicasOfNodes(sourceNodes, clusterState);
        HashMap<Replica, String> replicaMovements = CollectionUtil.newHashMap(sourceReplicas.size());
        if (targetNodes.size() > 1) {
            ArrayList<Assign.AssignRequest> assignRequests = new ArrayList<Assign.AssignRequest>(sourceReplicas.size());
            ArrayList<String> targetNodeList = new ArrayList<String>(targetNodes);
            for (Replica sourceReplica : sourceReplicas) {
                Replica.Type replicaType = sourceReplica.getType();
                Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(sourceReplica.getCollection()).forShard(Collections.singletonList(sourceReplica.getShard())).assignNrtReplicas(replicaType == Replica.Type.NRT ? 1 : 0).assignTlogReplicas(replicaType == Replica.Type.TLOG ? 1 : 0).assignPullReplicas(replicaType == Replica.Type.PULL ? 1 : 0).onNodes(targetNodeList).build();
                assignRequests.add(assignRequest);
            }
            Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
            List<ReplicaPosition> replicaPositions = assignStrategy.assign(this.ccc.getSolrCloudManager(), assignRequests);
            int position = 0;
            for (Replica sourceReplica : sourceReplicas) {
                replicaMovements.put(sourceReplica, replicaPositions.get((int)position++).node);
            }
        } else {
            String targetNode = (String)targetNodes.stream().findFirst().get();
            for (Replica sourceReplica : sourceReplicas) {
                replicaMovements.put(sourceReplica, targetNode);
            }
        }
        if (migrationSuccessful = ReplicaMigrationUtils.migrateReplicas(this.ccc, replicaMovements, parallel, waitForFinalState, timeout, async, results)) {
            results.add("success", "MIGRATE_REPLICAS action completed successfully from  : [" + String.join((CharSequence)",", sourceNodes) + "] to : [" + String.join((CharSequence)",", targetNodes) + "]");
        }
    }

    protected Set<String> getNodesFromParam(ZkNodeProps message, String paramName) {
        Object rawParam = message.get(paramName);
        if (rawParam == null) {
            return Collections.emptySet();
        }
        if (rawParam instanceof Set) {
            return (Set)rawParam;
        }
        if (rawParam instanceof Collection) {
            return new HashSet<String>((Collection)rawParam);
        }
        if (rawParam instanceof String) {
            return Set.of(((String)rawParam).split(","));
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'" + paramName + "' was not passed as a correct type (Set/List/String): " + rawParam.getClass().getName());
    }
}

