/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.events;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cluster.events.ClusterEvent;
import org.apache.solr.cluster.events.ClusterEventListener;
import org.apache.solr.cluster.events.ClusterEventProducer;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterEventProducerBase
implements ClusterEventProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final Map<ClusterEvent.EventType, Set<ClusterEventListener>> listeners = new ConcurrentHashMap<ClusterEvent.EventType, Set<ClusterEventListener>>();
    protected volatile ClusterSingleton.State state = ClusterSingleton.State.STOPPED;
    protected final CoreContainer cc;

    protected ClusterEventProducerBase(CoreContainer cc) {
        this.cc = cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(ClusterEventListener listener, ClusterEvent.EventType ... eventTypes) {
        if (eventTypes == null || eventTypes.length == 0) {
            eventTypes = ClusterEvent.EventType.values();
        }
        for (ClusterEvent.EventType type : eventTypes) {
            if (!this.getSupportedEventTypes().contains((Object)type)) {
                log.warn("event type {} not supported yet.", (Object)type);
                continue;
            }
            Map<ClusterEvent.EventType, Set<ClusterEventListener>> map = this.listeners;
            synchronized (map) {
                this.listeners.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet()).add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(ClusterEventListener listener, ClusterEvent.EventType ... eventTypes) {
        if (eventTypes == null || eventTypes.length == 0) {
            eventTypes = ClusterEvent.EventType.values();
        }
        Map<ClusterEvent.EventType, Set<ClusterEventListener>> map = this.listeners;
        synchronized (map) {
            for (ClusterEvent.EventType type : eventTypes) {
                Set<ClusterEventListener> perType = this.listeners.get((Object)type);
                if (perType == null) continue;
                perType.remove(listener);
                if (!perType.isEmpty()) continue;
                this.listeners.remove((Object)type);
            }
        }
    }

    @Override
    public ClusterSingleton.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<ClusterEvent.EventType, Set<ClusterEventListener>> map = this.listeners;
        synchronized (map) {
            this.listeners.values().forEach(listenerSet -> listenerSet.forEach(listener -> IOUtils.closeQuietly(listener)));
        }
    }

    public abstract Set<ClusterEvent.EventType> getSupportedEventTypes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(ClusterEvent event) {
        Map<ClusterEvent.EventType, Set<ClusterEventListener>> map = this.listeners;
        synchronized (map) {
            this.listeners.getOrDefault((Object)event.getType(), Collections.emptySet()).forEach(listener -> {
                if (log.isDebugEnabled()) {
                    log.debug("--- firing event {} to {}", (Object)event, listener);
                }
                listener.onEvent(event);
            });
        }
    }
}

