/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.events.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.Phaser;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cluster.events.ClusterEvent;
import org.apache.solr.cluster.events.ClusterEventListener;
import org.apache.solr.cluster.events.ClusterEventProducer;
import org.apache.solr.cluster.events.ClusterEventProducerBase;
import org.apache.solr.cluster.events.NoOpProducer;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegatingClusterEventProducer
extends ClusterEventProducerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ClusterEventProducer delegate;
    private volatile Phaser phaser;

    public DelegatingClusterEventProducer(CoreContainer cc) {
        super(cc);
        this.delegate = new NoOpProducer(cc);
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("--closing delegate for CC-{}: {}", (Object)Integer.toHexString(this.cc.hashCode()), (Object)this.delegate);
        }
        IOUtils.closeQuietly(this.delegate);
        super.close();
    }

    @VisibleForTesting
    public void setDelegationPhaser(Phaser phaser) {
        phaser.register();
        this.phaser = phaser;
    }

    public void setDelegate(ClusterEventProducer newDelegate) {
        Phaser localPhaser;
        if (log.isDebugEnabled()) {
            log.debug("--setting new delegate for CC-{}: {}", (Object)Integer.toHexString(this.cc.hashCode()), (Object)newDelegate);
        }
        this.delegate = newDelegate;
        this.listeners.forEach((type, listenerSet) -> listenerSet.forEach(listener -> {
            try {
                this.delegate.registerListener((ClusterEventListener)listener, (ClusterEvent.EventType)((Object)type));
            }
            catch (Exception e) {
                log.warn("Exception registering listener with the new event producer", (Throwable)e);
                this.delegate.unregisterListener((ClusterEventListener)listener, (ClusterEvent.EventType)((Object)type));
                super.unregisterListener((ClusterEventListener)listener, (ClusterEvent.EventType)((Object)type));
            }
        }));
        if ((this.state == ClusterSingleton.State.RUNNING || this.state == ClusterSingleton.State.STARTING) && this.delegate.getState() != ClusterSingleton.State.RUNNING && this.delegate.getState() != ClusterSingleton.State.STARTING) {
            try {
                this.delegate.start();
                if (log.isDebugEnabled()) {
                    log.debug("--- started delegate {}", (Object)this.delegate);
                }
            }
            catch (Exception e) {
                log.warn("Unable to start the new delegate {}: {}", (Object)this.delegate.getClass().getName(), (Object)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("--- delegate {} already in state {}", (Object)this.delegate, (Object)this.delegate.getState());
        }
        if ((localPhaser = this.phaser) != null) {
            assert (localPhaser.getRegisteredParties() == 1);
            localPhaser.arrive();
        }
    }

    @Override
    public void registerListener(ClusterEventListener listener, ClusterEvent.EventType ... eventTypes) {
        super.registerListener(listener, eventTypes);
        this.delegate.registerListener(listener, eventTypes);
    }

    @Override
    public void unregisterListener(ClusterEventListener listener, ClusterEvent.EventType ... eventTypes) {
        super.unregisterListener(listener, eventTypes);
        this.delegate.unregisterListener(listener, eventTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void start() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("-- starting CC-{}, Delegating {}, delegate {}", new Object[]{Integer.toHexString(this.cc.hashCode()), Integer.toHexString(this.hashCode()), this.delegate});
        }
        this.state = ClusterSingleton.State.STARTING;
        if (this.delegate.getState() != ClusterSingleton.State.RUNNING && this.delegate.getState() != ClusterSingleton.State.STARTING) {
            try {
                this.delegate.start();
                if (!log.isDebugEnabled()) return;
                log.debug("--- started delegate {}", (Object)this.delegate);
                return;
            }
            finally {
                this.state = this.delegate.getState();
            }
        } else {
            if (!log.isDebugEnabled()) return;
            log.debug("--- delegate {} already in state {}", (Object)this.delegate, (Object)this.delegate.getState());
        }
    }

    @Override
    public Set<ClusterEvent.EventType> getSupportedEventTypes() {
        return NoOpProducer.ALL_EVENT_TYPES;
    }

    @Override
    public synchronized void stop() {
        if (log.isDebugEnabled()) {
            log.debug("-- stopping Delegating {}, delegate {}", (Object)Integer.toHexString(this.hashCode()), (Object)this.delegate);
        }
        this.state = ClusterSingleton.State.STOPPING;
        this.delegate.stop();
        this.state = this.delegate.getState();
    }
}

