/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterProperties {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String EXT_PROPRTTY_PREFIX = "ext.";
    private final SolrZkClient client;

    public ClusterProperties(SolrZkClient client) {
        this.client = client;
    }

    public <T> T getClusterProperty(String key, T defaultValue) throws IOException {
        Object value = Utils.getObjectByPath(this.getClusterProperties(), false, key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> T getClusterProperty(List<String> key, T defaultValue) throws IOException {
        Object value = Utils.getObjectByPath(this.getClusterProperties(), false, key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Map<String, Object> getClusterProperties() throws IOException {
        try {
            Map properties = (Map)Utils.fromJSON(this.client.getData("/clusterprops.json", null, new Stat(), true));
            return properties;
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted(e));
        }
    }

    public void setClusterProperties(Map<String, Object> properties) throws IOException, KeeperException, InterruptedException {
        this.client.atomicUpdate("/clusterprops.json", zkData -> {
            if (zkData == null) {
                return Utils.toJSON(properties);
            }
            Map zkJson = (Map)Utils.fromJSON(zkData);
            boolean modified = Utils.mergeJson(zkJson, properties);
            return modified ? Utils.toJSON(zkJson) : null;
        });
    }

    public void update(MapWriter obj, String ... path) throws KeeperException, InterruptedException {
        this.client.atomicUpdate("/clusterprops.json", bytes -> {
            Map zkJson = bytes == null ? new LinkedHashMap() : (Map)Utils.fromJSON(bytes);
            Utils.setObjectByPath(zkJson, Arrays.asList(path), (Object)obj);
            return Utils.toJSON(zkJson);
        });
    }

    public void setClusterProperty(String propertyName, Object propertyValue) throws IOException {
        this.validatePropertyName(propertyName);
        while (true) {
            Stat s = new Stat();
            try {
                if (this.client.exists("/clusterprops.json", true).booleanValue()) {
                    Map properties = (Map)Utils.fromJSON(this.client.getData("/clusterprops.json", null, s, true));
                    if (propertyValue == null) {
                        if (properties.get(propertyName) == null) break;
                        properties.remove(propertyName);
                        this.client.setData("/clusterprops.json", Utils.toJSON(properties), s.getVersion(), true);
                        break;
                    }
                    if (propertyValue.equals(properties.get(propertyName))) break;
                    properties.put(propertyName, propertyValue);
                    this.client.setData("/clusterprops.json", Utils.toJSON(properties), s.getVersion(), true);
                    break;
                }
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                properties.put(propertyName, propertyValue);
                this.client.makePath("/clusterprops.json", Utils.toJSON(properties), CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                continue;
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Error setting cluster property", SolrZkClient.checkInterrupted(e));
            }
            break;
        }
    }

    private void validatePropertyName(String propertyName) {
        if (!ZkStateReader.KNOWN_CLUSTER_PROPS.contains(propertyName) && !propertyName.startsWith(EXT_PROPRTTY_PREFIX)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not a known cluster property or starts with prefix ext., propertyName: " + propertyName);
        }
    }
}

