/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SecurityAwareZkACLProvider;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestZkACLProvider
extends SecurityAwareZkACLProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DigestZkACLProvider() {
    }

    public DigestZkACLProvider(ZkCredentialsInjector zkCredentialsInjector) {
        super(zkCredentialsInjector);
    }

    @Override
    protected List<ACL> createNonSecurityACLsToAdd() {
        return this.createACLsToAdd(true);
    }

    @Override
    protected List<ACL> createSecurityACLsToAdd() {
        return this.createACLsToAdd(false);
    }

    protected List<ACL> createACLsToAdd(boolean includeReadOnly) {
        ArrayList result = new ArrayList();
        List<ZkCredentialsInjector.ZkCredential> zkCredentials = this.zkCredentialsInjector.getZkCredentials();
        log.debug("createACLsToAdd using ZkCredentials: {}", zkCredentials);
        for (ZkCredentialsInjector.ZkCredential zkCredential : zkCredentials) {
            int perms;
            if (StrUtils.isNullOrEmpty(zkCredential.getUsername()) || StrUtils.isNullOrEmpty(zkCredential.getPassword())) continue;
            Id id = this.createACLId(zkCredential.getUsername(), zkCredential.getPassword());
            if (zkCredential.isAll()) {
                perms = 31;
            } else {
                if (!includeReadOnly || !zkCredential.isReadonly()) continue;
                perms = 1;
            }
            result.add(new ACL(perms, id));
        }
        if (result.isEmpty()) {
            result = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return result;
    }

    protected Id createACLId(String username, String password) {
        try {
            return new Id("digest", DigestAuthenticationProvider.generateDigest((String)(username + ":" + password)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM mis-configured: missing SHA-1 algorithm", (Throwable)e);
        }
    }
}

