/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

class RequiredValidator
extends Validator<List<String>> {
    private Set<String> requiredProps;

    RequiredValidator(Map<?, ?> schema, List<String> requiredProps) {
        super(schema, requiredProps);
        this.requiredProps = new HashSet<String>(requiredProps);
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        return this.validate(o, errs, this.requiredProps);
    }

    boolean validate(Object o, List<String> errs, Set<String> requiredProps) {
        if (o instanceof Map) {
            Set fnames = ((Map)o).keySet();
            for (String requiredProp : requiredProps) {
                if (requiredProp.contains(".")) {
                    if (requiredProp.endsWith(".")) {
                        errs.add("Illegal required attribute name (ends with '.': " + requiredProp + ").  This is a bug.");
                        return false;
                    }
                    String subprop = requiredProp.substring(requiredProp.indexOf(46) + 1);
                    if (this.validate(((Map)o).get(requiredProp), errs, Collections.singleton(subprop))) continue;
                    return false;
                }
                if (fnames.contains(requiredProp)) continue;
                errs.add("Missing required attribute '" + requiredProp + "' in object " + Utils.toJSONString(o));
                return false;
            }
            return true;
        }
        return false;
    }
}

