/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.tracing.SimplePropagator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TracerConfigurator
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final boolean TRACE_ID_GEN_ENABLED = Boolean.parseBoolean(EnvUtils.getProperty("solr.alwaysOnTraceId", "true"));
    private static final String DEFAULT_CLASS_NAME = EnvUtils.getProperty("solr.otelDefaultConfigurator", "org.apache.solr.opentelemetry.OtelTracerConfigurator");

    public abstract Tracer getTracer();

    public static Tracer loadTracer(SolrResourceLoader loader, PluginInfo info) {
        if (info != null && info.isEnabled()) {
            GlobalTracer.registerIfAbsent(() -> {
                TracerConfigurator configurator = loader.newInstance(info.className, TracerConfigurator.class);
                configurator.init(info.initArgs);
                return configurator.getTracer();
            });
        } else if (TracerConfigurator.shouldAutoConfigOTEL()) {
            GlobalTracer.registerIfAbsent(() -> TracerConfigurator.autoConfigOTEL(loader));
        } else if (TRACE_ID_GEN_ENABLED) {
            SimplePropagator.load();
        }
        if (GlobalTracer.isRegistered()) {
            ExecutorUtil.addThreadLocalProvider(new SpanThreadLocalProvider());
        }
        return GlobalTracer.get();
    }

    private static Tracer autoConfigOTEL(SolrResourceLoader loader) {
        try {
            TracerConfigurator configurator = loader.newInstance(DEFAULT_CLASS_NAME, TracerConfigurator.class);
            configurator.init(new NamedList());
            return configurator.getTracer();
        }
        catch (SolrException e) {
            log.error("Unable to auto-config OpenTelemetry with class {}. Make sure you have enabled the 'opentelemetry' module", (Object)DEFAULT_CLASS_NAME, (Object)e);
            return GlobalTracer.get();
        }
    }

    static boolean shouldAutoConfigOTEL() {
        Map<String, String> env = System.getenv();
        boolean isSdkDisabled = Boolean.parseBoolean(TracerConfigurator.getConfig("OTEL_SDK_DISABLED", env));
        if (isSdkDisabled) {
            return false;
        }
        return TracerConfigurator.getConfig("OTEL_SERVICE_NAME", env) != null;
    }

    protected static String getConfig(String envName, Map<String, String> env) {
        String sysName = TracerConfigurator.envNameToSyspropName(envName);
        String sysValue = System.getProperty(sysName);
        String envValue = env.get(envName);
        return sysValue != null ? sysValue : envValue;
    }

    protected static String envNameToSyspropName(String envName) {
        return envName.toLowerCase(Locale.ROOT).replace("_", ".");
    }

    private static class SpanThreadLocalProvider
    implements ExecutorUtil.InheritableThreadLocalProvider {
        private final Tracer tracer = GlobalTracer.get();

        private SpanThreadLocalProvider() {
        }

        @Override
        public void store(AtomicReference<Object> ctx) {
            assert (this.tracer == GlobalTracer.get()) : "Tracer changed; not supported!";
            ctx.set(this.tracer.scopeManager().activeSpan());
        }

        @Override
        public void set(AtomicReference<Object> ctx) {
            Span span = (Span)ctx.get();
            if (span != null) {
                log.trace("Thread received span to do async work: {}", (Object)span);
                Scope scope = this.tracer.scopeManager().activate(span);
                ctx.set(scope);
            }
        }

        @Override
        public void clean(AtomicReference<Object> ctx) {
            Scope scope = (Scope)ctx.get();
            if (scope != null) {
                scope.close();
            }
        }
    }
}

