/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public interface BackupRepository
extends NamedListInitializedPlugin,
Closeable {
    default public String getBackupLocation(String override) {
        return Optional.ofNullable(override).orElse((String)this.getConfigProperty("location"));
    }

    public <T> T getConfigProperty(String var1);

    public URI createURI(String var1);

    default public URI createDirectoryURI(String path) {
        return this.createURI(path);
    }

    public URI resolve(URI var1, String ... var2);

    default public URI resolveDirectory(URI baseUri, String ... pathComponents) {
        return this.resolve(baseUri, pathComponents);
    }

    public boolean exists(URI var1) throws IOException;

    public PathType getPathType(URI var1) throws IOException;

    public String[] listAll(URI var1) throws IOException;

    public IndexInput openInput(URI var1, String var2, IOContext var3) throws IOException;

    public OutputStream createOutput(URI var1) throws IOException;

    public void createDirectory(URI var1) throws IOException;

    public void deleteDirectory(URI var1) throws IOException;

    default public void copyFileFrom(Directory sourceDir, String fileName, URI dest) throws IOException {
        this.copyIndexFileFrom(sourceDir, fileName, dest, fileName);
    }

    default public void copyFileTo(URI sourceRepo, String fileName, Directory dest) throws IOException {
        this.copyIndexFileTo(sourceRepo, fileName, dest, fileName);
    }

    default public String[] listAllOrEmpty(URI path) {
        try {
            return this.listAll(path);
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, Directory destDir, String destFileName) throws IOException {
        boolean success = false;
        try {
            try (ChecksumIndexInput is = sourceDir.openChecksumInput(sourceFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
                 IndexOutput os = destDir.createOutput(destFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);){
                os.copyBytes(is, is.length() - (long)CodecUtil.footerLength());
                CodecUtil.checkFooter(is);
                CodecUtil.writeFooter(os);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.deleteFilesIgnoringExceptions(destDir, destFileName);
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions(destDir, destFileName);
    }

    @Deprecated
    default public void delete(URI path, Collection<String> files, boolean ignoreNoSuchFileException) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void delete(URI path, Collection<String> files) throws IOException {
        this.delete(path, files, true);
    }

    default public Checksum checksum(Directory dir, String fileName) throws IOException {
        try (ChecksumIndexInput in = dir.openChecksumInput(fileName, IOContext.READONCE);){
            Checksum checksum = new Checksum(CodecUtil.retrieveChecksum(in), in.length());
            return checksum;
        }
    }

    default public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void copyIndexFileTo(URI sourceRepo, String sourceFileName, Directory dest, String destFileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static enum PathType {
        DIRECTORY,
        FILE;

    }
}

