/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.request.beans.ClusterPropPayload;
import org.apache.solr.client.solrj.request.beans.RateLimiterPayload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;

public class ClusterAPI {
    private final CollectionsHandler collectionsHandler;
    private final ConfigSetsHandler configSetsHandler;
    public final Commands commands = new Commands();

    public ClusterAPI(CollectionsHandler ch, ConfigSetsHandler configSetsHandler) {
        this.collectionsHandler = ch;
        this.configSetsHandler = configSetsHandler;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/node-roles"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void roles(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("node-roles", this.readRecursive("/node_roles", this.collectionsHandler.getCoreContainer().getZkController().getSolrCloudManager().getDistribStateManager(), 3));
    }

    Object readRecursive(String path, DistribStateManager zk, int depth) {
        HashMap<String, Object> result;
        if (depth == 0) {
            return null;
        }
        try {
            List<String> children = zk.listData(path);
            if (children == null || children.isEmpty()) {
                return Collections.emptySet();
            }
            result = new HashMap<String, Object>();
            for (String child : children) {
                Object c = this.readRecursive(path + "/" + child, zk, depth - 1);
                result.put(child, c);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (depth == 1) {
            return result.keySet();
        }
        return result;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/node-roles/role/{role}"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void nodesWithRole(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String role = req.getPathTemplateValues().get("role");
        rsp.add("node-roles", Map.of(role, this.readRecursive("/node_roles/" + role, this.collectionsHandler.getCoreContainer().getZkController().getSolrCloudManager().getDistribStateManager(), 2)));
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/node-roles/node/{node}"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void rolesForNode(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String node = req.getPathTemplateValues().get("node");
        HashMap<String, String> ret = new HashMap<String, String>();
        Map roles = (Map)this.readRecursive("/node_roles", this.collectionsHandler.getCoreContainer().getZkController().getSolrCloudManager().getDistribStateManager(), 3);
        for (String role : roles.keySet()) {
            for (String mode : ((Map)roles.get(role)).keySet()) {
                Set nodes;
                if (((Set)((Map)roles.get(role)).get(mode)).isEmpty() || !(nodes = (Set)((Map)roles.get(role)).get(mode)).contains(node)) continue;
                ret.put(role, mode);
            }
        }
        for (String role : ret.keySet()) {
            rsp.add(role, ret.get(role));
        }
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/node-roles/supported"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void supportedRoles(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        HashMap<String, Map<String, Set<String>>> roleModesSupportedMap = new HashMap<String, Map<String, Set<String>>>();
        for (NodeRoles.Role role : NodeRoles.Role.values()) {
            roleModesSupportedMap.put(role.toString(), Map.of("modes", role.supportedModes()));
        }
        rsp.add("supported-roles", roleModesSupportedMap);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/node-roles/role/{role}/{mode}"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void nodesWithRoleMode(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String roleStr = req.getPathTemplateValues().get("role");
        String modeStr = req.getPathTemplateValues().get("mode");
        List<String> nodes = this.collectionsHandler.getCoreContainer().getZkController().getSolrCloudManager().getDistribStateManager().listData("/node_roles/" + roleStr + "/" + modeStr);
        rsp.add("node-roles", Map.of(roleStr, Collections.singletonMap(modeStr, nodes)));
    }

    public static List<String> getNodesByRole(NodeRoles.Role role, String mode, DistribStateManager zk) throws InterruptedException, IOException, KeeperException {
        try {
            return zk.listData("/node_roles/" + role + "/" + mode);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyList();
        }
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/overseer"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getOverseerStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, "action", CollectionParams.CollectionAction.OVERSEERSTATUS.lowerName), rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.DELETE}, path={"/cluster/command-status/{id}"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public void deleteCommandStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Map<String, Object> v1Params = Map.of("action", CollectionParams.CollectionAction.DELETESTATUS.lowerName, "requestid", req.getPathTemplateValues().get("id"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, v1Params), rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.DELETE}, path={"/cluster/command-status"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public void flushCommandStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CollectionsHandler.CollectionOperation.DELETESTATUS_OP.execute(req, rsp, this.collectionsHandler);
    }

    public static SolrQueryRequest wrapParams(SolrQueryRequest req, Object ... def) {
        Map<String, Object> m = Utils.makeMap(def);
        return ClusterAPI.wrapParams(req, m);
    }

    public static SolrQueryRequest wrapParams(SolrQueryRequest req, Map<String, Object> m) {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        m.forEach((k, v) -> {
            if (v == null) {
                return;
            }
            if (v instanceof String[]) {
                solrParams.add((String)k, (String[])v);
            } else {
                solrParams.add((String)k, String.valueOf(v));
            }
        });
        DefaultSolrParams dsp = new DefaultSolrParams(req.getParams(), solrParams);
        req.setParams(dsp);
        return req;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/command-status/{id}"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getCommandStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Map<String, Object> v1Params = Map.of("action", CollectionParams.CollectionAction.REQUESTSTATUS.lowerName, "requestid", req.getPathTemplateValues().get("id"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, v1Params), rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/nodes"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getNodes(SolrQueryRequest req, SolrQueryResponse rsp) {
        rsp.add("nodes", this.getCoreContainer().getZkController().getClusterState().getLiveNodes());
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getClusterStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Map<String, Object> v1Params = Map.of("action", CollectionParams.CollectionAction.CLUSTERSTATUS.toLower());
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, v1Params), rsp);
    }

    private CoreContainer getCoreContainer() {
        return this.collectionsHandler.getCoreContainer();
    }

    public static class RoleInfo
    implements ReflectMapWriter {
        @JsonProperty(required=true)
        public String node;
        @JsonProperty(required=true)
        public String role;
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public class Commands {
        @Command(name="add-role")
        public void addRole(PayloadObj<RoleInfo> obj) throws Exception {
            RoleInfo info = obj.get();
            Map<String, Object> m = info.toMap(new HashMap<String, Object>());
            m.put("action", CollectionParams.CollectionAction.ADDROLE.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }

        @Command(name="remove-role")
        public void removeRole(PayloadObj<RoleInfo> obj) throws Exception {
            RoleInfo info = obj.get();
            Map<String, Object> m = info.toMap(new HashMap<String, Object>());
            m.put("action", CollectionParams.CollectionAction.REMOVEROLE.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }

        @Command(name="set-obj-property")
        public void setObjProperty(PayloadObj<ClusterPropPayload> obj) {
            Map<String, Object> m = obj.getDataMap();
            ClusterProperties clusterProperties = new ClusterProperties(ClusterAPI.this.getCoreContainer().getZkController().getZkClient());
            try {
                clusterProperties.setClusterProperties(m);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in API", (Throwable)e);
            }
        }

        @Command(name="set-property")
        public void setProperty(PayloadObj<Map<String, String>> obj) throws Exception {
            Map<String, Object> m = obj.getDataMap();
            m.put("action", CollectionParams.CollectionAction.CLUSTERPROP.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }

        @Command(name="set-ratelimiter")
        public void setRateLimiters(PayloadObj<RateLimiterPayload> payLoad) {
            RateLimiterPayload rateLimiterConfig = payLoad.get();
            ClusterProperties clusterProperties = new ClusterProperties(ClusterAPI.this.getCoreContainer().getZkController().getZkClient());
            try {
                clusterProperties.update(rateLimiterConfig, "rate-limiters");
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in API", (Throwable)e);
            }
        }
    }
}

