/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private SolrCore solrCore;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<String> subpaths;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String[] returnParams;
        rsp.add("params", req.getParams().toNamedList());
        String[] parts = req.getParams().getParams("urlTemplateValues");
        if (parts != null && parts.length > 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            rsp.getValues().add("urlTemplateValues", map);
            for (String part : parts) {
                map.put(part, req.getPathTemplateValues().get(part));
            }
        }
        if ((returnParams = req.getParams().getParams("param")) != null) {
            NamedList params = (NamedList)rsp.getValues().get("params");
            for (String returnParam : returnParams) {
                String[] vals = req.getParams().getParams(returnParam);
                if (vals == null) continue;
                if (vals.length == 1) {
                    params.add(returnParam, vals[0]);
                    continue;
                }
                params.add(returnParam, vals);
            }
        }
        if (req.getParams().getBool("getdefaults", false)) {
            NamedList def = (NamedList)this.initArgs.get("defaults");
            rsp.add("getdefaults", def);
        }
        if (req.getParams().getBool("initArgs", false)) {
            rsp.add("initArgs", this.initArgs);
        }
        if (req.getContentStreams() != null) {
            ArrayList streams = new ArrayList();
            for (ContentStream content : req.getContentStreams()) {
                SimpleOrderedMap<Object> stream = new SimpleOrderedMap<Object>();
                stream.add("name", content.getName());
                stream.add("sourceInfo", content.getSourceInfo());
                stream.add("size", content.getSize());
                stream.add("contentType", content.getContentType());
                stream.add("stream", StrUtils.stringFromReader(content.getReader()));
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    @Override
    public String getDescription() {
        return "Dump handler (debug)";
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        if (this.subpaths != null && this.subpaths.contains(subPath)) {
            return this;
        }
        return null;
    }

    @Override
    public void init(NamedList<?> args) {
        NamedList nl;
        super.init(args);
        if (args != null && (nl = (NamedList)args.get("defaults")) != null) {
            this.subpaths = nl.getAll("subpath");
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        if (this.solrCore != null && this.solrCore.getSolrConfig().getRequestParsers().isEnableRemoteStreams()) {
            log.warn("Dump request handler requires config-read permission when remote streams are enabled");
            return PermissionNameProvider.Name.CONFIG_READ_PERM;
        }
        return PermissionNameProvider.Name.ALL;
    }

    @Override
    public void inform(SolrCore core) {
        this.solrCore = core;
    }
}

