/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.api.ClusterPluginsSource;
import org.apache.solr.api.Command;
import org.apache.solr.api.ContainerPluginsRegistry;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPluginsApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PLUGIN = "plugin";
    private final CoreContainer coreContainer;
    private final ClusterPluginsSource pluginsSource;
    public final Read readAPI = new Read();
    public final Edit editAPI = new Edit();

    public ContainerPluginsApi(CoreContainer coreContainer, ClusterPluginsSource clusterPluginsSource) {
        this.coreContainer = coreContainer;
        this.pluginsSource = clusterPluginsSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateConfig(PayloadObj<PluginMeta> payload, PluginMeta info) throws IOException {
        if (info.klass.indexOf(58) > 0 && info.version == null) {
            payload.addError("Using package. must provide a packageVersion");
            return;
        }
        ArrayList<String> errs = new ArrayList<String>();
        ContainerPluginsRegistry.ApiInfo apiInfo = this.coreContainer.getContainerPluginsRegistry().createInfo(payload.getDataMap(), errs);
        if (!errs.isEmpty()) {
            for (String err : errs) {
                payload.addError(err);
            }
            return;
        }
        Object api = null;
        try {
            apiInfo.init();
        }
        catch (Exception e) {
            try {
                log.error("Error instantiating plugin ", (Throwable)e);
                errs.add(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(new Closeable[]{api});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(new Closeable[]{api});
            return;
        }
        IOUtils.closeWhileHandlingException(new Closeable[]{api});
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster/plugin"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public class Edit {
        @Command(name="add")
        public void add(PayloadObj<PluginMeta> payload) throws IOException {
            PluginMeta info = payload.get();
            ContainerPluginsApi.this.validateConfig(payload, info);
            if (payload.hasError()) {
                return;
            }
            ContainerPluginsApi.this.pluginsSource.persistPlugins(map -> {
                if (map.containsKey(info.name)) {
                    payload.addError(info.name + " already exists");
                    return null;
                }
                map.put(info.name, payload.getDataMap());
                return map;
            });
        }

        @Command(name="remove")
        public void remove(PayloadObj<String> payload) throws IOException {
            ContainerPluginsApi.this.pluginsSource.persistPlugins(map -> {
                if (map.remove(payload.get()) == null) {
                    payload.addError("No such plugin: " + (String)payload.get());
                    return null;
                }
                return map;
            });
        }

        @Command(name="update")
        public void update(PayloadObj<PluginMeta> payload) throws IOException {
            PluginMeta info = payload.get();
            ContainerPluginsApi.this.validateConfig(payload, info);
            if (payload.hasError()) {
                return;
            }
            ContainerPluginsApi.this.pluginsSource.persistPlugins(map -> {
                Map existing = (Map)map.get(info.name);
                if (existing == null) {
                    payload.addError("No such plugin: " + info.name);
                    return null;
                }
                Map<String, Object> jsonObj = payload.getDataMap();
                if (Objects.equals(jsonObj, existing)) {
                    return null;
                }
                map.put(info.name, jsonObj);
                return map;
            });
        }
    }

    public class Read {
        @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/plugin"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
        public void list(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
            rsp.add(ContainerPluginsApi.PLUGIN, ContainerPluginsApi.this.pluginsSource.plugins());
        }
    }
}

