/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.api.NodePropertiesAPI;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class PropertiesRequestHandler
extends RequestHandlerBase {
    private CoreContainer cc;

    public PropertiesRequestHandler() {
        this(null);
    }

    public PropertiesRequestHandler(CoreContainer cc) {
        this.cc = cc;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SimpleOrderedMap<String> props = new SimpleOrderedMap<String>();
        String name = req.getParams().get("name");
        NodeConfig nodeConfig = this.getCoreContainer(req).getNodeConfig();
        if (name != null) {
            String property = nodeConfig.getRedactedSysPropValue(name);
            props.add(name, property);
        } else {
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                props.add(name, nodeConfig.getRedactedSysPropValue(name));
            }
        }
        rsp.add("system.properties", props);
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Get System Properties";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Collection<Api> getApis() {
        return AnnotatedApi.getApis(new NodePropertiesAPI(this));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.CONFIG_READ_PERM;
    }

    private CoreContainer getCoreContainer(SolrQueryRequest req) {
        CoreContainer coreContainer = req.getCoreContainer();
        return coreContainer == null ? this.cc : coreContainer;
    }
}

