/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.IndexSizeEstimator;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentsInfoRequestHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FIELD_INFO_PARAM = "fieldInfo";
    public static final String CORE_INFO_PARAM = "coreInfo";
    public static final String SIZE_INFO_PARAM = "sizeInfo";
    public static final String RAW_SIZE_PARAM = "rawSize";
    public static final String RAW_SIZE_SUMMARY_PARAM = "rawSizeSummary";
    public static final String RAW_SIZE_DETAILS_PARAM = "rawSizeDetails";
    public static final String RAW_SIZE_SAMPLING_PERCENT_PARAM = "rawSizeSamplingPercent";
    private static final List<String> FI_LEGEND = Arrays.asList(FieldFlag.INDEXED.toString(), FieldFlag.DOC_VALUES.toString(), "xxx - DocValues type", FieldFlag.TERM_VECTOR_STORED.toString(), FieldFlag.OMIT_NORMS.toString(), FieldFlag.OMIT_TF.toString(), FieldFlag.OMIT_POSITIONS.toString(), FieldFlag.STORE_OFFSETS_WITH_POSITIONS.toString(), "p - field has payloads", "s - field uses soft deletes", ":x:x:x - point data dim : index dim : num bytes");
    private static final double GB = 1.073741824E9;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.getSegmentsInfo(req, rsp);
        rsp.setHttpCaching(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSegmentsInfo(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Version commitVersion;
        boolean withFieldInfo = req.getParams().getBool(FIELD_INFO_PARAM, false);
        boolean withCoreInfo = req.getParams().getBool(CORE_INFO_PARAM, false);
        boolean withSizeInfo = req.getParams().getBool(SIZE_INFO_PARAM, false);
        boolean withRawSizeInfo = req.getParams().getBool(RAW_SIZE_PARAM, false);
        boolean withRawSizeSummary = req.getParams().getBool(RAW_SIZE_SUMMARY_PARAM, false);
        boolean withRawSizeDetails = req.getParams().getBool(RAW_SIZE_DETAILS_PARAM, false);
        if (withRawSizeSummary || withRawSizeDetails) {
            withRawSizeInfo = true;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        SegmentInfos infos = SegmentInfos.readLatestCommit(searcher.getIndexReader().directory());
        SimpleOrderedMap<SimpleOrderedMap<Object>> segmentInfos = new SimpleOrderedMap<SimpleOrderedMap<Object>>();
        SolrCore core = req.getCore();
        SimpleOrderedMap<Object> infosInfo = new SimpleOrderedMap<Object>();
        Version minVersion = infos.getMinSegmentLuceneVersion();
        if (minVersion != null) {
            infosInfo.add("minSegmentLuceneVersion", minVersion.toString());
        }
        if ((commitVersion = infos.getCommitLuceneVersion()) != null) {
            infosInfo.add("commitLuceneVersion", commitVersion.toString());
        }
        infosInfo.add("numSegments", infos.size());
        infosInfo.add("segmentsFileName", infos.getSegmentsFileName());
        infosInfo.add("totalMaxDoc", infos.totalMaxDoc());
        infosInfo.add("userData", infos.userData);
        if (withCoreInfo) {
            SimpleOrderedMap<Object> coreInfo = new SimpleOrderedMap<Object>();
            infosInfo.add("core", coreInfo);
            coreInfo.add("startTime", core.getStartTimeStamp().getTime() + "(" + core.getStartTimeStamp() + ")");
            coreInfo.add("dataDir", core.getDataDir());
            coreInfo.add("indexDir", core.getIndexDir());
            coreInfo.add("sizeInGB", (double)core.getIndexSize() / 1.073741824E9);
            RefCounted<IndexWriter> iwRef = core.getSolrCoreState().getIndexWriter(core);
            if (iwRef != null) {
                try {
                    String[] lines;
                    IndexWriter iw = iwRef.get();
                    String iwConfigStr = iw.getConfig().toString();
                    SimpleOrderedMap<String> iwConfig = new SimpleOrderedMap<String>();
                    for (String line : lines = iwConfigStr.split("\\n")) {
                        String[] parts = line.split("=");
                        if (parts.length < 2) continue;
                        iwConfig.add(parts[0], parts[1]);
                    }
                    coreInfo.add("indexWriterConfig", iwConfig);
                }
                finally {
                    iwRef.decref();
                }
            }
        }
        ArrayList<SegmentCommitInfo> sortable = new ArrayList<SegmentCommitInfo>(infos.asList());
        sortable.sort((s1, s2) -> s2.info.maxDoc() - s2.getDelCount() - (s1.info.maxDoc() - s1.getDelCount()));
        ArrayList<String> mergeCandidates = new ArrayList<String>();
        SimpleOrderedMap<Object> runningMerges = this.getMergeInformation(req, infos, mergeCandidates);
        List<LeafReaderContext> leafContexts = searcher.getIndexReader().leaves();
        IndexSchema schema = req.getSchema();
        for (SegmentCommitInfo segmentCommitInfo : sortable) {
            SimpleOrderedMap<Object> segmentInfo = this.getSegmentInfo(segmentCommitInfo, withSizeInfo, withFieldInfo, leafContexts, schema);
            if (mergeCandidates.contains(segmentCommitInfo.info.name)) {
                segmentInfo.add("mergeCandidate", true);
            }
            segmentInfos.add((String)segmentInfo.get("name"), segmentInfo);
        }
        rsp.add("info", infosInfo);
        if (runningMerges.size() > 0) {
            rsp.add("runningMerges", runningMerges);
        }
        if (withFieldInfo) {
            rsp.add("fieldInfoLegend", FI_LEGEND);
        }
        rsp.add("segments", segmentInfos);
        if (withRawSizeInfo) {
            IndexSizeEstimator estimator = new IndexSizeEstimator(searcher.getRawReader(), 20, 100, withRawSizeSummary, withRawSizeDetails);
            String samplingPercentVal = req.getParams().get(RAW_SIZE_SAMPLING_PERCENT_PARAM);
            if (samplingPercentVal != null) {
                estimator.setSamplingPercent(Float.parseFloat(String.valueOf(samplingPercentVal)));
            }
            IndexSizeEstimator.Estimate estimate = estimator.estimate();
            SimpleOrderedMap<Map<String, Object>> estimateMap = new SimpleOrderedMap<Map<String, Object>>();
            estimateMap.add("fieldsBySize", estimate.getHumanReadableFieldsBySize());
            estimateMap.add("typesBySize", estimate.getHumanReadableTypesBySize());
            if (estimate.getSummary() != null) {
                estimateMap.add("summary", estimate.getSummary());
            }
            if (estimate.getDetails() != null) {
                estimateMap.add("details", estimate.getDetails());
            }
            rsp.add(RAW_SIZE_PARAM, estimateMap);
        }
    }

    private SimpleOrderedMap<Object> getSegmentInfo(SegmentCommitInfo segmentCommitInfo, boolean withSizeInfo, boolean withFieldInfos, List<LeafReaderContext> leafContexts, IndexSchema schema) throws IOException {
        LeafMetaData metaData;
        SimpleOrderedMap<Object> segmentInfoMap = new SimpleOrderedMap<Object>();
        segmentInfoMap.add("name", segmentCommitInfo.info.name);
        segmentInfoMap.add("delCount", segmentCommitInfo.getDelCount());
        segmentInfoMap.add("softDelCount", segmentCommitInfo.getSoftDelCount());
        segmentInfoMap.add("hasFieldUpdates", segmentCommitInfo.hasFieldUpdates());
        segmentInfoMap.add("sizeInBytes", segmentCommitInfo.sizeInBytes());
        segmentInfoMap.add("size", segmentCommitInfo.info.maxDoc());
        Long timestamp = Long.parseLong(segmentCommitInfo.info.getDiagnostics().get("timestamp"));
        segmentInfoMap.add("age", new Date(timestamp));
        segmentInfoMap.add("source", segmentCommitInfo.info.getDiagnostics().get("source"));
        segmentInfoMap.add("version", segmentCommitInfo.info.getVersion().toString());
        SegmentReader seg = null;
        for (LeafReaderContext lrc : leafContexts) {
            LeafReader leafReader = lrc.reader();
            if (!((leafReader = FilterLeafReader.unwrap(leafReader)) instanceof SegmentReader)) continue;
            SegmentReader sr = (SegmentReader)leafReader;
            if (!sr.getSegmentInfo().info.equals(segmentCommitInfo.info)) continue;
            seg = sr;
            break;
        }
        if (seg != null && (metaData = seg.getMetaData()) != null) {
            segmentInfoMap.add("createdVersionMajor", metaData.getCreatedVersionMajor());
            segmentInfoMap.add("minVersion", metaData.getMinVersion().toString());
            if (metaData.getSort() != null) {
                segmentInfoMap.add("sort", metaData.getSort().toString());
            }
        }
        if (!segmentCommitInfo.info.getDiagnostics().isEmpty()) {
            segmentInfoMap.add("diagnostics", segmentCommitInfo.info.getDiagnostics());
        }
        if (!segmentCommitInfo.info.getAttributes().isEmpty()) {
            segmentInfoMap.add("attributes", segmentCommitInfo.info.getAttributes());
        }
        if (withSizeInfo) {
            Directory dir = segmentCommitInfo.info.dir;
            List files = segmentCommitInfo.files().stream().map(f -> {
                long size = -1L;
                try {
                    size = dir.fileLength((String)f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new Pair<String, Long>((String)f, size);
            }).sorted((p1, p2) -> {
                if ((Long)p1.second() > (Long)p2.second()) {
                    return -1;
                }
                if ((Long)p1.second() < (Long)p2.second()) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            if (!files.isEmpty()) {
                SimpleOrderedMap<String> topFiles = new SimpleOrderedMap<String>();
                for (int i = 0; i < Math.min(files.size(), 5); ++i) {
                    Pair p = (Pair)files.get(i);
                    topFiles.add((String)p.first(), RamUsageEstimator.humanReadableUnits((Long)p.second()));
                }
                segmentInfoMap.add("largestFiles", topFiles);
            }
        }
        if (withFieldInfos) {
            if (seg == null) {
                log.debug("Skipping segment info - not available as a SegmentReader: {}", (Object)segmentCommitInfo);
            } else {
                FieldInfos fis = seg.getFieldInfos();
                SimpleOrderedMap<SimpleOrderedMap<Object>> fields = new SimpleOrderedMap<SimpleOrderedMap<Object>>();
                for (FieldInfo fi : fis) {
                    fields.add(fi.name, this.getFieldInfo(seg, fi, schema));
                }
                segmentInfoMap.add("fields", fields);
            }
        }
        return segmentInfoMap;
    }

    private SimpleOrderedMap<Object> getFieldInfo(SegmentReader reader, FieldInfo fi, IndexSchema schema) {
        boolean hasPoints;
        SimpleOrderedMap<Object> fieldFlags = new SimpleOrderedMap<Object>();
        StringBuilder flags = new StringBuilder();
        IndexOptions opts = fi.getIndexOptions();
        flags.append(opts != IndexOptions.NONE ? (char)FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        DocValuesType dvt = fi.getDocValuesType();
        if (dvt != DocValuesType.NONE) {
            flags.append(FieldFlag.DOC_VALUES.getAbbreviation());
            switch (dvt) {
                case NUMERIC: {
                    flags.append("num");
                    break;
                }
                case BINARY: {
                    flags.append("bin");
                    break;
                }
                case SORTED: {
                    flags.append("srt");
                    break;
                }
                case SORTED_NUMERIC: {
                    flags.append("srn");
                    break;
                }
                case SORTED_SET: {
                    flags.append("srs");
                    break;
                }
                default: {
                    flags.append("???");
                    break;
                }
            }
        } else {
            flags.append("----");
        }
        flags.append(fi.hasVectors() ? (char)FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(fi.omitsNorms() ? (char)FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS == opts ? (char)FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS_AND_FREQS == opts ? (char)FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS == opts ? (char)FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(fi.hasPayloads() ? "p" : "-");
        flags.append(fi.isSoftDeletesField() ? "s" : "-");
        if (fi.getPointDimensionCount() > 0 || fi.getPointIndexDimensionCount() > 0) {
            flags.append(":");
            flags.append(fi.getPointDimensionCount()).append(':');
            flags.append(fi.getPointIndexDimensionCount()).append(':');
            flags.append(fi.getPointNumBytes());
        }
        fieldFlags.add("flags", flags.toString());
        try {
            Terms terms = reader.terms(fi.name);
            if (terms != null) {
                fieldFlags.add("docCount", terms.getDocCount());
                fieldFlags.add("sumDocFreq", terms.getSumDocFreq());
                fieldFlags.add("sumTotalTermFreq", terms.getSumTotalTermFreq());
            }
        }
        catch (Exception e) {
            log.debug("Exception retrieving term stats for field {}", (Object)fi.name, (Object)e);
        }
        SchemaField sf = schema.getFieldOrNull(fi.name);
        boolean bl = hasPoints = fi.getPointDimensionCount() > 0 || fi.getPointIndexDimensionCount() > 0;
        if (sf != null) {
            fieldFlags.add("schemaType", sf.getType().getTypeName());
            SimpleOrderedMap<Object> nonCompliant = new SimpleOrderedMap<Object>();
            if (sf.hasDocValues() && fi.getDocValuesType() == DocValuesType.NONE && fi.getIndexOptions() != IndexOptions.NONE) {
                nonCompliant.add("docValues", "schema=" + sf.getType().getUninversionType(sf) + ", segment=false");
            }
            if (!sf.hasDocValues() && fi.getDocValuesType() != DocValuesType.NONE) {
                nonCompliant.add("docValues", "schema=false, segment=" + fi.getDocValuesType().toString());
            }
            if (!sf.isPolyField() && sf.indexed() != (fi.getIndexOptions() != IndexOptions.NONE || hasPoints)) {
                nonCompliant.add("indexed", "schema=" + sf.indexed() + ", segment=" + fi.getIndexOptions());
            }
            if (!hasPoints && sf.omitNorms() != fi.omitsNorms()) {
                nonCompliant.add("omitNorms", "schema=" + sf.omitNorms() + ", segment=" + fi.omitsNorms());
            }
            if (sf.storeTermVector() != fi.hasVectors()) {
                nonCompliant.add("termVectors", "schema=" + sf.storeTermVector() + ", segment=" + fi.hasVectors());
            }
            if (sf.storeOffsetsWithPositions() != (fi.getIndexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS)) {
                nonCompliant.add("storeOffsetsWithPositions", "schema=" + sf.storeOffsetsWithPositions() + ", segment=" + fi.getIndexOptions());
            }
            if (nonCompliant.size() > 0) {
                nonCompliant.add("schemaField", sf.toString());
                fieldFlags.add("nonCompliant", nonCompliant);
            }
        } else {
            fieldFlags.add("schemaType", "(UNKNOWN)");
        }
        return fieldFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleOrderedMap<Object> getMergeInformation(SolrQueryRequest req, SegmentInfos infos, List<String> mergeCandidates) throws IOException {
        SimpleOrderedMap<Object> result = new SimpleOrderedMap<Object>();
        RefCounted<IndexWriter> refCounted = req.getCore().getSolrCoreState().getIndexWriter(req.getCore());
        try {
            MergePolicy mp;
            MergePolicy.MergeSpecification findMerges;
            IndexWriter indexWriter = refCounted.get();
            if (indexWriter instanceof SolrIndexWriter) {
                result.addAll(((SolrIndexWriter)indexWriter).getRunningMerges());
            }
            if ((findMerges = (mp = indexWriter.getConfig().getMergePolicy()).findMerges(MergeTrigger.EXPLICIT, infos, indexWriter)) != null && findMerges.merges != null && findMerges.merges.size() > 0) {
                for (MergePolicy.OneMerge merge : findMerges.merges) {
                    for (SegmentCommitInfo mergeSegmentInfo : merge.segments) {
                        mergeCandidates.add(mergeSegmentInfo.info.name);
                    }
                }
            }
            SimpleOrderedMap<Object> simpleOrderedMap = result;
            return simpleOrderedMap;
        }
        finally {
            refCounted.decref();
        }
    }

    @Override
    public String getDescription() {
        return "Lucene segments info.";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }
}

