/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.http.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFileRequestHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final String HIDDEN = "hidden";
    public static final String USE_CONTENT_TYPE = "contentType";
    private static final Set<String> KNOWN_MIME_TYPES;
    protected Set<String> hiddenFiles;
    private static final Logger log;

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        this.hiddenFiles = ShowFileRequestHandler.initHidden(this.invariants);
    }

    public static Set<String> initHidden(SolrParams invariants) {
        String[] hidden;
        HashSet<String> hiddenRet = new HashSet<String>();
        if (invariants != null && (hidden = invariants.getParams(HIDDEN)) != null) {
            for (String s : hidden) {
                hiddenRet.add(s.toUpperCase(Locale.ROOT));
            }
        }
        return hiddenRet;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException, IOException {
        CoreContainer coreContainer = req.getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            this.showFromZooKeeper(req, rsp, coreContainer);
        } else {
            this.showFromFileSystem(req, rsp);
        }
    }

    private void showFromZooKeeper(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer coreContainer) throws KeeperException, InterruptedException, UnsupportedEncodingException {
        SolrZkClient zkClient = coreContainer.getZkController().getZkClient();
        String adminFile = ShowFileRequestHandler.getAdminFileFromZooKeeper(req, rsp, zkClient, this.hiddenFiles);
        if (adminFile == null) {
            return;
        }
        List<String> children = zkClient.getChildren(adminFile, null, true);
        if (children.size() > 0) {
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (String f : children) {
                if (ShowFileRequestHandler.isHiddenFile(req, rsp, f, false, this.hiddenFiles)) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(f, fileInfo);
                List<String> fchildren = zkClient.getChildren(adminFile + "/" + f, null, true);
                if (fchildren.size() > 0) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                    continue;
                }
                fileInfo.add("size", Integer.valueOf(f.length()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.ByteArrayStream content = new ContentStreamBase.ByteArrayStream(zkClient.getData(adminFile, null, null, true), adminFile);
            content.setContentType(ShowFileRequestHandler.getSafeContentType(req.getParams().get(USE_CONTENT_TYPE)));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    private void showFromFileSystem(SolrQueryRequest req, SolrQueryResponse rsp) {
        Path admin = ShowFileRequestHandler.getAdminFileFromFileSystem(req, rsp, this.hiddenFiles);
        if (admin == null) {
            return;
        }
        File adminFile = admin.toFile();
        if (!adminFile.exists()) {
            log.error("Can not find: {} [{}]", (Object)adminFile.getName(), (Object)adminFile.getAbsolutePath());
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]"));
            return;
        }
        if (!adminFile.canRead() || adminFile.isHidden()) {
            log.error("Can not show: {} [{}]", (Object)adminFile.getName(), (Object)adminFile.getAbsolutePath());
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]"));
            return;
        }
        if (adminFile.isDirectory()) {
            int basePath = adminFile.getAbsolutePath().length() + 1;
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (File f : adminFile.listFiles()) {
                String path = f.getAbsolutePath().substring(basePath);
                path = path.replace('\\', '/');
                if (ShowFileRequestHandler.isHiddenFile(req, rsp, f.getName().replace('\\', '/'), false, this.hiddenFiles)) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(path, fileInfo);
                if (f.isDirectory()) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                } else {
                    fileInfo.add("size", Long.valueOf(f.length()));
                }
                fileInfo.add("modified", new Date(f.lastModified()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.FileStream content = new ContentStreamBase.FileStream(adminFile);
            content.setContentType(ShowFileRequestHandler.getSafeContentType(req.getParams().get(USE_CONTENT_TYPE)));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    public static String getSafeContentType(String contentType) {
        if (StrUtils.isNullOrEmpty(contentType)) {
            log.debug("No contentType specified");
            return null;
        }
        String rawContentType = contentType.split(";")[0].trim().toLowerCase(Locale.ROOT);
        if (!KNOWN_MIME_TYPES.contains(rawContentType)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Requested content type '" + contentType + "' is not supported.");
        }
        if (rawContentType.contains("html")) {
            log.info("Using text/plain instead of {}", (Object)contentType);
            return "text/plain";
        }
        return contentType;
    }

    public static boolean isHiddenFile(SolrQueryRequest req, SolrQueryResponse rsp, String fnameIn, boolean reportError, Set<String> hiddenFiles) {
        String fname = fnameIn.toUpperCase(Locale.ROOT);
        if (hiddenFiles.contains(fname) || hiddenFiles.contains("*")) {
            if (reportError) {
                log.error("Cannot access {}", (Object)fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fnameIn));
            }
            return true;
        }
        if (fname.contains("..") || fname.startsWith(".")) {
            if (reportError) {
                log.error("Invalid path: {}", (Object)fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fnameIn));
            }
            return true;
        }
        return false;
    }

    public static String getAdminFileFromZooKeeper(SolrQueryRequest req, SolrQueryResponse rsp, SolrZkClient zkClient, Set<String> hiddenFiles) throws KeeperException, InterruptedException {
        Object adminFile = null;
        SolrCore core = req.getCore();
        ZkSolrResourceLoader loader = (ZkSolrResourceLoader)core.getResourceLoader();
        String confPath = loader.getConfigSetZkPath();
        String fname = req.getParams().get("file", null);
        if (fname == null) {
            adminFile = confPath;
        } else {
            if (ShowFileRequestHandler.isHiddenFile(req, rsp, fname = fname.replace('\\', '/'), true, hiddenFiles)) {
                return null;
            }
            if (fname.startsWith("/")) {
                fname = fname.substring(1);
            }
            adminFile = confPath + "/" + fname;
        }
        if (!zkClient.exists((String)adminFile, true).booleanValue()) {
            log.error("Can not find: {}", adminFile);
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not find: " + (String)adminFile));
            return null;
        }
        return adminFile;
    }

    public static Path getAdminFileFromFileSystem(SolrQueryRequest req, SolrQueryResponse rsp, Set<String> hiddenFiles) {
        String fname;
        SolrResourceLoader loader = req.getCore().getResourceLoader();
        Path configDir = loader.getConfigPath();
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                configDir = Path.of(loader.getClassLoader().getResource(loader.getConfigDir()).toURI());
            }
            catch (URISyntaxException e) {
                log.error("Can not access configuration directory!");
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access configuration directory!", (Throwable)e));
                return null;
            }
        }
        if ((fname = req.getParams().get("file", null)) == null) {
            return configDir;
        }
        if (hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase(Locale.ROOT))) {
            log.error("Can not access: {}", (Object)fname);
            rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname));
            return null;
        }
        Path filePath = configDir.resolve(fname.startsWith("/") ? fname.substring(1) : fname);
        req.getCoreContainer().assertPathAllowed(filePath);
        if (!filePath.normalize().startsWith(configDir.normalize())) {
            log.error("Path must be inside core config directory");
            rsp.setException(new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path must be inside core config directory"));
            return null;
        }
        return filePath;
    }

    public final Set<String> getHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public String getDescription() {
        return "Admin Config File -- view or update config files directly";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.CONFIG_READ_PERM;
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        KNOWN_MIME_TYPES = new HashSet<String>(MimeTypes.getKnownMimeTypes());
        KNOWN_MIME_TYPES.add("text/xml");
        KNOWN_MIME_TYPES.add("text/javascript");
    }
}

