/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.api.NodeThreadsAPI;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class ThreadDumpHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        NamedList<SimpleOrderedMap<Object>> lst;
        ThreadInfo[] tinfos;
        SimpleOrderedMap system = new SimpleOrderedMap();
        rsp.add("system", system);
        ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
        SimpleOrderedMap<Integer> nl = new SimpleOrderedMap<Integer>();
        nl.add("current", tmbean.getThreadCount());
        nl.add("peak", tmbean.getPeakThreadCount());
        nl.add("daemon", tmbean.getDaemonThreadCount());
        system.add("threadCount", nl);
        long[] tids = tmbean.findDeadlockedThreads();
        if (tids != null) {
            tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
            lst = new NamedList<SimpleOrderedMap<Object>>();
            for (ThreadInfo ti : tinfos) {
                if (ti == null) continue;
                lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
            }
            system.add("deadlocks", lst);
        }
        tinfos = tmbean.dumpAllThreads(true, true);
        lst = new NamedList();
        for (ThreadInfo ti : tinfos) {
            if (ti == null) continue;
            lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
        }
        system.add("threadDump", lst);
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getThreadInfo(ThreadInfo ti, ThreadMXBean tmbean) {
        MonitorInfo[] monitors;
        ArrayList<String> locks;
        LockInfo[] synchronizers;
        LockInfo lockInfo;
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        long tid = ti.getThreadId();
        info.add("id", tid);
        info.add("name", ti.getThreadName());
        info.add("state", ti.getThreadState().toString());
        if (ti.getLockName() != null) {
            info.add("lock", ti.getLockName());
        }
        if (null != (lockInfo = ti.getLockInfo())) {
            SimpleOrderedMap<Object> lock = new SimpleOrderedMap<Object>();
            info.add("lock-waiting", lock);
            lock.add("name", lockInfo.toString());
            if (-1L == ti.getLockOwnerId() && null == ti.getLockOwnerName()) {
                lock.add("owner", null);
            } else {
                SimpleOrderedMap<Object> owner = new SimpleOrderedMap<Object>();
                lock.add("owner", owner);
                owner.add("name", ti.getLockOwnerName());
                owner.add("id", ti.getLockOwnerId());
            }
        }
        if (0 < (synchronizers = ti.getLockedSynchronizers()).length) {
            locks = new ArrayList<String>(synchronizers.length);
            info.add("synchronizers-locked", locks);
            for (LockInfo sync : synchronizers) {
                locks.add(sync.toString());
            }
        }
        if (0 < (monitors = ti.getLockedMonitors()).length) {
            locks = new ArrayList(monitors.length);
            info.add("monitors-locked", locks);
            for (MonitorInfo monitor : monitors) {
                locks.add(monitor.toString());
            }
        }
        if (ti.isSuspended()) {
            info.add("suspended", true);
        }
        if (ti.isInNative()) {
            info.add("native", true);
        }
        if (tmbean.isThreadCpuTimeSupported()) {
            info.add("cpuTime", ThreadDumpHandler.formatNanos(tmbean.getThreadCpuTime(tid)));
            info.add("userTime", ThreadDumpHandler.formatNanos(tmbean.getThreadUserTime(tid)));
        }
        int i = 0;
        String[] trace = new String[ti.getStackTrace().length];
        for (StackTraceElement ste : ti.getStackTrace()) {
            trace[i++] = ste.toString();
        }
        info.add("stackTrace", trace);
        return info;
    }

    private static String formatNanos(long ns) {
        return String.format(Locale.ROOT, "%.4fms", (double)ns / 1000000.0);
    }

    @Override
    public String getDescription() {
        return "Thread Dump";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Collection<Api> getApis() {
        return AnnotatedApi.getApis(new NodeThreadsAPI(this));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }
}

