/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import org.apache.solr.client.api.endpoint.AddReplicaPropertyApi;
import org.apache.solr.client.api.model.AddReplicaPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class AddReplicaProperty
extends AdminAPIBase
implements AddReplicaPropertyApi {
    @Inject
    public AddReplicaProperty(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse addReplicaProperty(String collName, String shardName, String replicaName, String propertyName, AddReplicaPropertyRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        AddReplicaProperty.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = this.createRemoteMessage(collName, shardName, replicaName, propertyName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.ADDREPLICAPROP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(String collName, String shardName, String replicaName, String propertyName, AddReplicaPropertyRequestBody requestBody) {
        boolean uniquePerSlice;
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("collection", collName);
        remoteMessage.put("property", propertyName);
        remoteMessage.put("shard", shardName);
        remoteMessage.put("replica", replicaName);
        remoteMessage.put("property.value", requestBody.value);
        remoteMessage.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        if (requestBody.shardUnique != null) {
            remoteMessage.put("shardUnique", requestBody.shardUnique);
        }
        String prefixedPropertyName = "property." + propertyName;
        boolean bl = uniquePerSlice = requestBody.shardUnique == null ? false : requestBody.shardUnique;
        if (requestBody.shardUnique != null && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prefixedPropertyName.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + prefixedPropertyName + " with the shardUnique parameter set to something other than 'true'. No action taken.");
        }
        return new ZkNodeProps(remoteMessage);
    }
}

