/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.lucene.index.IndexCommit;
import org.apache.solr.client.api.endpoint.CoreSnapshotApi;
import org.apache.solr.client.api.model.CreateCoreSnapshotResponse;
import org.apache.solr.client.api.model.DeleteSnapshotResponse;
import org.apache.solr.client.api.model.ListCoreSnapshotsResponse;
import org.apache.solr.client.api.model.SnapshotInformation;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CoreSnapshot
extends CoreAdminAPIBase
implements CoreSnapshotApi {
    @Inject
    public CoreSnapshot(SolrQueryRequest request, SolrQueryResponse response, CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, request, response);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public CreateCoreSnapshotResponse createSnapshot(String coreName, String snapshotName, String taskId) throws Exception {
        CreateCoreSnapshotResponse response = this.instantiateJerseyResponse(CreateCoreSnapshotResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, taskId, "createSnapshot", () -> {
            try (SolrCore core = this.coreContainer.getCore(coreName);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
                }
                String indexDirPath = core.getIndexDir();
                IndexDeletionPolicyWrapper delPol = core.getDeletionPolicy();
                IndexCommit ic = delPol.getAndSaveLatestCommit();
                try {
                    if (null == ic) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No index commits to snapshot in core " + coreName);
                    }
                    SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
                    mgr.snapshot(snapshotName, indexDirPath, ic.getGeneration());
                    response.core = core.getName();
                    response.commitName = snapshotName;
                    response.indexDirPath = indexDirPath;
                    response.generation = ic.getGeneration();
                    response.files = ic.getFileNames();
                }
                catch (IOException e) {
                    throw new CoreAdminAPIBase.CoreAdminAPIBaseException(e);
                }
                finally {
                    delPol.releaseCommitPoint(ic);
                }
            }
            return response;
        });
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public ListCoreSnapshotsResponse listSnapshots(String coreName) throws Exception {
        ListCoreSnapshotsResponse response = this.instantiateJerseyResponse(ListCoreSnapshotsResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, null, "listSnapshots", () -> {
            try (SolrCore core = this.coreContainer.getCore(coreName);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
                }
                SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
                HashMap<String, SnapshotInformation> result = new HashMap<String, SnapshotInformation>();
                for (String name : mgr.listSnapshots()) {
                    Optional<SolrSnapshotMetaDataManager.SnapshotMetaData> metadata = mgr.getSnapshotMetaData(name);
                    if (!metadata.isPresent()) continue;
                    SnapshotInformation snapshotInformation = new SnapshotInformation(metadata.get().getGenerationNumber(), metadata.get().getIndexDirPath());
                    result.put(name, snapshotInformation);
                }
                response.snapshots = result;
            }
            return response;
        });
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public DeleteSnapshotResponse deleteSnapshot(String coreName, String snapshotName, String taskId) throws Exception {
        DeleteSnapshotResponse response = this.instantiateJerseyResponse(DeleteSnapshotResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, taskId, "deleteSnapshot", () -> {
            SolrCore core = this.coreContainer.getCore(coreName);
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
            }
            try {
                try {
                    core.deleteNamedSnapshot(snapshotName);
                }
                catch (IOException e) {
                    throw new CoreAdminAPIBase.CoreAdminAPIBaseException(e);
                }
                response.coreName = coreName;
                response.commitName = snapshotName;
            }
            finally {
                core.close();
            }
            return response;
        });
    }
}

