/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.api.endpoint.CreateCollectionApi;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRouterProperties;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CreateCollection
extends AdminAPIBase
implements CreateCollectionApi {
    @Inject
    public CreateCollection(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createCollection(CreateCollectionRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request body is missing but required");
        }
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollection.recordCollectionForLogAndTracing(requestBody.name, this.solrQueryRequest);
        if (".system".equals(requestBody.name)) {
            requestBody.numShards = 1;
            requestBody.shardNames = null;
            CreateCollection.createSysConfigSet(coreContainer);
        }
        CreateCollection.validateRequestBody(requestBody);
        CreateCollection.populateDefaultsIfNecessary(coreContainer, requestBody);
        ZkNodeProps remoteMessage = CreateCollection.createRemoteMessage(requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (requestBody.async != null) {
            response.requestId = requestBody.async;
            return response;
        }
        response.successfulSubResponsesByNodeName = remoteResponse.getResponse().get("success");
        response.failedSubResponsesByNodeName = remoteResponse.getResponse().get("failure");
        response.warning = (String)remoteResponse.getResponse().get("warning");
        if (requestBody.async == null) {
            CollectionsHandler.waitForActiveCollection(requestBody.name, coreContainer, remoteResponse);
        }
        return response;
    }

    public static void populateDefaultsIfNecessary(CoreContainer coreContainer, CreateCollectionRequestBody requestBody) throws IOException {
        if (CollectionUtil.isEmpty(requestBody.shardNames) && requestBody.numShards == null) {
            requestBody.numShards = CreateCollection.readIntegerDefaultFromClusterProp(coreContainer, "numShards");
        }
        if (requestBody.nrtReplicas == null) {
            requestBody.nrtReplicas = CreateCollection.readIntegerDefaultFromClusterProp(coreContainer, "nrtReplicas");
        }
        if (requestBody.tlogReplicas == null) {
            requestBody.tlogReplicas = CreateCollection.readIntegerDefaultFromClusterProp(coreContainer, "tlogReplicas");
        }
        if (requestBody.pullReplicas == null) {
            requestBody.pullReplicas = CreateCollection.readIntegerDefaultFromClusterProp(coreContainer, "pullReplicas");
        }
    }

    private static void verifyShardsParam(List<String> shardNames) {
        for (String shard : shardNames) {
            SolrIdentifierValidator.validateShardName(shard);
        }
    }

    public static ZkNodeProps createRemoteMessage(CreateCollectionRequestBody reqBody) {
        HashMap<String, Object> rawProperties = new HashMap<String, Object>();
        rawProperties.put("fromApi", "true");
        rawProperties.put("operation", CollectionParams.CollectionAction.CREATE.toLower());
        rawProperties.put("name", reqBody.name);
        rawProperties.put("collection.configName", reqBody.config);
        rawProperties.put("numShards", reqBody.numShards);
        if (reqBody.shuffleNodes != null) {
            rawProperties.put("createNodeSet.shuffle", reqBody.shuffleNodes);
        }
        if (CollectionUtil.isNotEmpty(reqBody.shardNames)) {
            rawProperties.put("shards", String.join((CharSequence)",", reqBody.shardNames));
        }
        rawProperties.put("pullReplicas", reqBody.pullReplicas);
        rawProperties.put("tlogReplicas", reqBody.tlogReplicas);
        rawProperties.put("waitForFinalState", reqBody.waitForFinalState);
        rawProperties.put("perReplicaState", reqBody.perReplicaState);
        rawProperties.put("alias", reqBody.alias);
        rawProperties.put("async", reqBody.async);
        if (reqBody.createReplicas == null || reqBody.createReplicas.booleanValue()) {
            if (reqBody.nodeSet != null) {
                rawProperties.put("createNodeSet", String.join((CharSequence)",", reqBody.nodeSet));
            }
        } else {
            rawProperties.put("createNodeSet", "EMPTY");
        }
        if (reqBody.replicationFactor != null) {
            rawProperties.put("replicationFactor", reqBody.replicationFactor);
            if (reqBody.nrtReplicas == null) {
                rawProperties.put("nrtReplicas", reqBody.replicationFactor);
            }
        }
        if (reqBody.nrtReplicas != null) {
            rawProperties.put("nrtReplicas", reqBody.nrtReplicas);
            if (reqBody.replicationFactor == null) {
                rawProperties.put("replicationFactor", reqBody.nrtReplicas);
            }
        }
        if (reqBody.properties != null) {
            for (Map.Entry<String, String> entry : reqBody.properties.entrySet()) {
                rawProperties.put("property." + entry.getKey(), entry.getValue());
            }
        }
        if (reqBody.router != null) {
            CreateCollectionRouterProperties routerProps = reqBody.router;
            rawProperties.put("router.name", routerProps.name);
            rawProperties.put("router.field", routerProps.field);
        }
        return new ZkNodeProps(rawProperties);
    }

    public static Map<String, String> copyPrefixedPropertiesWithoutPrefix(SolrParams params, Map<String, String> props, String prefix) {
        Iterator<String> iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!param.startsWith(prefix)) continue;
            String[] values = params.getParams(param);
            if (values.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one value can be present for parameter " + param);
            }
            String modifiedKey = param.replaceFirst(prefix, "");
            props.put(modifiedKey, values[0]);
        }
        return props;
    }

    private static Integer readIntegerDefaultFromClusterProp(CoreContainer coreContainer, String propName) throws IOException {
        Object defaultValue = new ClusterProperties(coreContainer.getZkController().getZkStateReader().getZkClient()).getClusterProperty(List.of("defaults", "collection", propName), null);
        if (defaultValue == null) {
            return null;
        }
        return Integer.valueOf(String.valueOf(defaultValue));
    }

    private static void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
        SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
        ZkMaintenanceUtils.ensureExists("/configs", zk);
        ZkMaintenanceUtils.ensureExists("/configs/.system", zk);
        try {
            byte[] data;
            String path = "/configs/.system/schema.xml";
            try (InputStream inputStream = CollectionsHandler.class.getResourceAsStream("/SystemCollectionSchema.xml");){
                assert (inputStream != null);
                data = inputStream.readAllBytes();
            }
            assert (data != null && data.length > 0);
            ZkMaintenanceUtils.ensureExists(path, data, CreateMode.PERSISTENT, zk);
            path = "/configs/.system/solrconfig.xml";
            inputStream = CollectionsHandler.class.getResourceAsStream("/SystemCollectionSolrConfig.xml");
            try {
                assert (inputStream != null);
                data = inputStream.readAllBytes();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            assert (data != null && data.length > 0);
            ZkMaintenanceUtils.ensureExists(path, data, CreateMode.PERSISTENT, zk);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static CreateCollectionRequestBody createRequestBodyFromV1Params(SolrParams params, boolean nameRequired) {
        CreateCollectionRequestBody requestBody = new CreateCollectionRequestBody();
        requestBody.name = nameRequired ? params.required().get("name") : params.get("name");
        requestBody.replicationFactor = params.getInt("replicationFactor");
        requestBody.config = params.get("collection.configName");
        requestBody.numShards = params.getInt("numShards");
        if (params.get("createNodeSet") != null) {
            String commaDelimNodeSet = params.get("createNodeSet");
            if ("EMPTY".equals(commaDelimNodeSet)) {
                requestBody.createReplicas = false;
            } else {
                requestBody.nodeSet = Arrays.asList(params.get("createNodeSet").split(","));
            }
        }
        requestBody.shuffleNodes = params.getBool("createNodeSet.shuffle");
        requestBody.shardNames = params.get("shards") != null ? Arrays.stream(params.get("shards").split(",")).collect(Collectors.toList()) : new ArrayList<String>();
        requestBody.tlogReplicas = params.getInt("tlogReplicas");
        requestBody.pullReplicas = params.getInt("pullReplicas");
        requestBody.nrtReplicas = params.getInt("nrtReplicas");
        requestBody.waitForFinalState = params.getBool("waitForFinalState");
        requestBody.perReplicaState = params.getBool("perReplicaState");
        requestBody.alias = params.get("alias");
        requestBody.async = params.get("async");
        requestBody.properties = CreateCollection.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
        if (params.get("router.name") != null || params.get("router.field") != null) {
            CreateCollectionRouterProperties routerProperties = new CreateCollectionRouterProperties();
            routerProperties.name = params.get("router.name");
            routerProperties.field = params.get("router.field");
            requestBody.router = routerProperties;
        }
        return requestBody;
    }

    public static void validateRequestBody(CreateCollectionRequestBody requestBody) {
        if (requestBody.replicationFactor != null && requestBody.nrtReplicas != null && !requestBody.replicationFactor.equals(requestBody.nrtReplicas)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot specify both replicationFactor and nrtReplicas as they mean the same thing");
        }
        SolrIdentifierValidator.validateCollectionName(requestBody.name);
        if (requestBody.shardNames != null && !requestBody.shardNames.isEmpty()) {
            CreateCollection.verifyShardsParam(requestBody.shardNames);
        }
    }

    public static void convertV2CreateCollectionMapToV1ParamMap(Map<String, Object> v2MapVals) {
        Set v2Keys = v2MapVals.keySet().stream().collect(Collectors.toSet());
        Iterator iterator = v2Keys.iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "properties": {
                    Map propertiesMap = (Map)v2MapVals.remove("properties");
                    V2ApiUtils.flattenMapWithPrefix(propertiesMap, v2MapVals, "property.");
                    break;
                }
                case "router": {
                    CreateCollectionRouterProperties routerProperties = (CreateCollectionRouterProperties)v2MapVals.remove("router");
                    Map<String, Object> routerPropertiesAsMap = Utils.reflectToMap(routerProperties);
                    V2ApiUtils.flattenMapWithPrefix(routerPropertiesAsMap, v2MapVals, "router.");
                    break;
                }
                case "config": {
                    v2MapVals.put("collection.configName", v2MapVals.remove("config"));
                    break;
                }
                case "shardNames": {
                    String shardsValue = String.join((CharSequence)",", (Collection)v2MapVals.remove("shardNames"));
                    v2MapVals.put("shards", shardsValue);
                    break;
                }
                case "shuffleNodes": {
                    v2MapVals.put("createNodeSet.shuffle", v2MapVals.remove("shuffleNodes"));
                    break;
                }
                case "nodeSet": {
                    Object nodeSetValUncast = v2MapVals.remove("nodeSet");
                    if (nodeSetValUncast instanceof String) {
                        v2MapVals.put("createNodeSet", nodeSetValUncast);
                        break;
                    }
                    List nodeSetList = (List)nodeSetValUncast;
                    String nodeSetStr = String.join((CharSequence)",", nodeSetList);
                    v2MapVals.put("createNodeSet", nodeSetStr);
                    break;
                }
            }
        }
    }

    public static void addToRemoteMessageWithPrefix(CreateCollectionRequestBody requestBody, Map<String, Object> remoteMessage, String prefix) {
        Map<String, Object> v1Params = Utils.reflectToMap(requestBody);
        CreateCollection.convertV2CreateCollectionMapToV1ParamMap(v1Params);
        for (Map.Entry<String, Object> v1Param : v1Params.entrySet()) {
            remoteMessage.put(prefix + v1Param.getKey(), v1Param.getValue());
        }
    }
}

