/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.model.AsyncJerseyResponse;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collName}/snapshots")
public class ListCollectionSnapshotsAPI
extends AdminAPIBase {
    @Inject
    public ListCollectionSnapshotsAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public ListSnapshotsResponse listSnapshots(@Parameter(description="The name of the collection.", required=true) @PathParam(value="collName") String collName) throws Exception {
        ListSnapshotsResponse response = this.instantiateJerseyResponse(ListSnapshotsResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ListCollectionSnapshotsAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        String collectionName = this.resolveCollectionName(collName, true);
        SolrZkClient client = coreContainer.getZkController().getZkClient();
        Collection<CollectionSnapshotMetaData> m = SolrSnapshotManager.listSnapshots(client, collectionName);
        HashMap<String, CollectionSnapshotMetaData> snapshots = CollectionUtil.newHashMap(m.size());
        for (CollectionSnapshotMetaData metaData : m) {
            snapshots.put(metaData.getName(), metaData);
        }
        response.snapshots = snapshots;
        return response;
    }

    public static class ListSnapshotsResponse
    extends AsyncJerseyResponse {
        @Schema(description="The snapshots for the collection.")
        @JsonProperty(value="snapshots")
        public Map<String, CollectionSnapshotMetaData> snapshots;
    }
}

