/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.MigrateReplicasApi;
import org.apache.solr.client.api.model.MigrateReplicasRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class MigrateReplicas
extends AdminAPIBase
implements MigrateReplicasApi {
    @Inject
    public MigrateReplicas(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse migrateReplicas(MigrateReplicasRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = this.createRemoteMessage(requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.MIGRATE_REPLICAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(MigrateReplicasRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        if (requestBody != null) {
            if (requestBody.sourceNodes == null || requestBody.sourceNodes.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No 'sourceNodes' provided in the request body. The MigrateReplicas API requires a 'sourceNodes' list in the request body.");
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No request body sent with request. The MigrateReplicas API requires a body.");
        }
        MigrateReplicas.insertIfNotNull(remoteMessage, "sourceNodes", requestBody.sourceNodes);
        MigrateReplicas.insertIfNotNull(remoteMessage, "targetNodes", requestBody.targetNodes);
        MigrateReplicas.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        MigrateReplicas.insertIfNotNull(remoteMessage, "async", requestBody.async);
        remoteMessage.put("operation", CollectionParams.CollectionAction.MIGRATE_REPLICAS.toLower());
        return new ZkNodeProps(remoteMessage);
    }
}

