/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.IOContext;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.admin.api.CoreReplicationAPI;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicationAPIBase
extends JerseyResource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCore solrCore;
    protected final SolrQueryRequest solrQueryRequest;
    protected final SolrQueryResponse solrQueryResponse;

    public ReplicationAPIBase(SolrCore solrCore, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this.solrCore = solrCore;
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    protected CoreReplicationAPI.IndexVersionResponse doFetchIndexVersion() throws IOException {
        ReplicationHandler replicationHandler = (ReplicationHandler)this.solrCore.getRequestHandler("/replication");
        return replicationHandler.getIndexVersionResponse();
    }

    protected CoreReplicationAPI.FileListResponse doFetchFileList(long generation) {
        ReplicationHandler replicationHandler = (ReplicationHandler)this.solrCore.getRequestHandler("/replication");
        return this.getFileList(generation, replicationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected CoreReplicationAPI.FileListResponse getFileList(long generation, ReplicationHandler replicationHandler) {
        delPol = this.solrCore.getDeletionPolicy();
        filesResponse = new CoreReplicationAPI.FileListResponse();
        commit = null;
        try {
            if (generation == -1L) {
                commit = delPol.getAndSaveLatestCommit();
                if (null == commit) {
                    filesResponse.fileList = Collections.emptyList();
                    var7_6 = filesResponse;
                    return var7_6;
                }
            } else {
                try {
                    commit = delPol.getAndSaveCommitPoint(generation);
                }
                catch (IllegalStateException var7_7) {
                    // empty catch block
                }
                if (null == commit) {
                    this.reportErrorOnResponse(filesResponse, "invalid index generation", null);
                    var7_8 = filesResponse;
                    return var7_8;
                }
            }
            if (!ReplicationAPIBase.$assertionsDisabled && null == commit) {
                throw new AssertionError();
            }
            result = new ArrayList<CoreReplicationAPI.FileMetaData>();
            dir = null;
            try {
                dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getNewIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
                infos = SegmentInfos.readCommit(dir, commit.getSegmentsFileName());
                for (SegmentCommitInfo commitInfo : infos) {
                    for (String file : commitInfo.files()) {
                        metaData = new CoreReplicationAPI.FileMetaData();
                        metaData.name = file;
                        metaData.size = dir.fileLength(file);
                        in = dir.openInput(file, IOContext.READONCE);
                        try {
                            try {
                                metaData.checksum = checksum = CodecUtil.retrieveChecksum(in);
                            }
                            catch (Exception e) {
                                ReplicationAPIBase.log.warn("Could not read checksum from index file: {}", (Object)file, (Object)e);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                        result.add(metaData);
                    }
                }
                fileMetaData = new CoreReplicationAPI.FileMetaData();
                fileMetaData.name = infos.getSegmentsFileName();
                fileMetaData.size = dir.fileLength(infos.getSegmentsFileName());
                if (infos.getId() != null) {
                    in = dir.openInput(infos.getSegmentsFileName(), IOContext.READONCE);
                    try {
                        try {
                            fileMetaData.checksum = CodecUtil.retrieveChecksum(in);
                        }
                        catch (Exception e) {
                            ReplicationAPIBase.log.warn("Could not read checksum from index file: {}", (Object)infos.getSegmentsFileName(), (Object)e);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                result.add(fileMetaData);
                ** if (dir == null) goto lbl-1000
            }
            catch (IOException e) {
                block50: {
                    try {
                        ReplicationAPIBase.log.error("Unable to get file names for indexCommit generation: {}", (Object)commit.getGeneration(), (Object)e);
                        this.reportErrorOnResponse(filesResponse, "unable to get file names for given index generation", e);
                        var10_15 = filesResponse;
                        if (dir == null) break block50;
                    }
                    catch (Throwable var18_29) {
                        if (dir != null) {
                            try {
                                this.solrCore.getDirectoryFactory().release(dir);
                            }
                            catch (IOException e) {
                                ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                            }
                        }
                        throw var18_29;
                    }
                    try {
                        this.solrCore.getDirectoryFactory().release(dir);
                    }
                    catch (IOException e) {
                        ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                    }
                }
                if (null != commit) {
                    delPol.setReserveDuration(commit.getGeneration(), replicationHandler.getReserveCommitDuration());
                    delPol.releaseCommitPoint(commit);
                }
                return var10_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.solrCore.getDirectoryFactory().release(dir);
                }
                catch (IOException e) {
                    ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            filesResponse.fileList = new ArrayList<CoreReplicationAPI.FileMetaData>(result);
            if (replicationHandler.getConfFileNameAlias().size() < 1 || this.solrCore.getCoreContainer().isZooKeeperAware()) {
                e = filesResponse;
                return e;
            }
            includeConfFiles = replicationHandler.getIncludeConfFiles();
            ReplicationAPIBase.log.debug("Adding config files to list: {}", (Object)includeConfFiles);
            filesResponse.confFiles = new ArrayList<CoreReplicationAPI.FileMetaData>(replicationHandler.getConfFileInfoFromCache(replicationHandler.getConfFileNameAlias(), replicationHandler.getConfFileInfoCache()));
            filesResponse.status = "OK";
        }
        finally {
            if (null != commit) {
                delPol.setReserveDuration(commit.getGeneration(), replicationHandler.getReserveCommitDuration());
                delPol.releaseCommitPoint(commit);
            }
        }
        return filesResponse;
    }

    private void reportErrorOnResponse(CoreReplicationAPI.FileListResponse fileListResponse, String message, Exception e) {
        fileListResponse.status = "ERROR";
        fileListResponse.message = message;
        if (e != null) {
            fileListResponse.exception = e;
        }
    }
}

