/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.handler.designer.SampleDocuments;
import org.apache.solr.handler.designer.SampleDocumentsLoader;
import org.apache.solr.handler.loader.CSVLoaderBase;
import org.apache.solr.handler.loader.JsonLoader;
import org.apache.solr.handler.loader.XMLLoader;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.SafeXMLParsing;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefaultSampleDocumentsLoader
implements SampleDocumentsLoader {
    public static final String CSV_MULTI_VALUE_DELIM_PARAM = "csvMultiValueDelimiter";
    private static final int MAX_STREAM_SIZE = 0x500000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static byte[] streamAsBytes(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try (InputStream inputStream = in;){
            int r;
            while ((r = in.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public SampleDocuments parseDocsFromStream(SolrParams params, ContentStream stream, int maxDocsToLoad) throws IOException {
        byte[] uploadedBytes;
        Long streamSize;
        String contentType = stream.getContentType();
        if (contentType == null) {
            return SampleDocuments.NONE;
        }
        if (params == null) {
            params = new ModifiableSolrParams();
        }
        if ((streamSize = stream.getSize()) != null && streamSize > 0x500000L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sample is too big! 5242880 bytes is the max upload size for sample documents.");
        }
        String fileSource = "paste";
        if ("file".equals(stream.getName())) {
            String string = fileSource = stream.getSourceInfo() != null ? stream.getSourceInfo() : "file";
        }
        if ((uploadedBytes = DefaultSampleDocumentsLoader.streamAsBytes(stream.getStream())).length > 0x500000) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sample is too big! 5242880 bytes is the max upload size for sample documents.");
        }
        ContentStreamBase.ByteArrayStream byteStream = new ContentStreamBase.ByteArrayStream(uploadedBytes, fileSource, contentType);
        String charset = ContentStreamBase.getCharsetFromContentType(stream.getContentType());
        if (charset == null) {
            charset = ContentStreamBase.DEFAULT_CHARSET;
        }
        List<SolrInputDocument> docs = null;
        if (stream.getSize() > 0L) {
            if (contentType.contains("application/json")) {
                docs = this.loadJsonDocs(params, byteStream, maxDocsToLoad);
            } else if (contentType.contains("text/xml") || contentType.contains("application/xml")) {
                docs = this.loadXmlDocs(params, byteStream, maxDocsToLoad);
            } else if (contentType.contains("text/csv") || contentType.contains("application/csv")) {
                docs = this.loadCsvDocs(params, fileSource, uploadedBytes, charset, maxDocsToLoad);
            } else if (contentType.contains("text/plain") || contentType.contains("application/octet-stream")) {
                docs = this.loadJsonLines(params, byteStream, maxDocsToLoad);
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, contentType + " not supported yet!");
            }
            if (docs != null && maxDocsToLoad > 0 && docs.size() > maxDocsToLoad) {
                docs = docs.subList(0, maxDocsToLoad);
            }
        }
        return new SampleDocuments(docs, contentType, fileSource);
    }

    protected List<SolrInputDocument> loadCsvDocs(SolrParams params, String source, byte[] streamBytes, String charset, int maxDocsToLoad) throws IOException {
        ContentStreamBase stream;
        if (params.get("separator") == null) {
            String csvStr = new String(streamBytes, charset);
            char sep = this.detectTSV(csvStr);
            ModifiableSolrParams modifiableSolrParams = new ModifiableSolrParams(params);
            modifiableSolrParams.set("separator", String.valueOf(sep));
            params = modifiableSolrParams;
            stream = new ContentStreamBase.StringStream(csvStr, "text/csv");
        } else {
            stream = new ContentStreamBase.ByteArrayStream(streamBytes, source, "text/csv");
        }
        return new SampleCSVLoader(new CSVRequest(params), maxDocsToLoad).loadDocs(stream);
    }

    protected List<SolrInputDocument> loadJsonLines(SolrParams params, ContentStreamBase.ByteArrayStream stream, int maxDocsToLoad) throws IOException {
        ArrayList<Map> docs = new ArrayList<Map>();
        try (Reader r = stream.getReader();){
            String line;
            BufferedReader br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                Object jsonLine;
                if (!(line = line.trim()).isEmpty() && line.startsWith("{") && line.endsWith("}") && (jsonLine = ObjectBuilder.getVal(new JSONParser(line))) instanceof Map) {
                    docs.add((Map)jsonLine);
                }
                if (maxDocsToLoad <= 0 || docs.size() != maxDocsToLoad) continue;
                break;
            }
        }
        return docs.stream().map(JsonLoader::buildDoc).collect(Collectors.toList());
    }

    protected List<SolrInputDocument> loadJsonDocs(SolrParams params, ContentStreamBase.ByteArrayStream stream, int maxDocsToLoad) throws IOException {
        List<Object> docs;
        Object json;
        try (Reader r = stream.getReader();){
            json = ObjectBuilder.getVal(new JSONParser(r));
        }
        if (json == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected at least 1 JSON doc in the request body!");
        }
        if (json instanceof List) {
            docs = (List)json;
        } else if (json instanceof Map) {
            boolean isJsonLines = false;
            String charset = ContentStreamBase.getCharsetFromContentType(stream.getContentType());
            String jsonStr = new String(DefaultSampleDocumentsLoader.streamAsBytes(stream.getStream()), charset != null ? charset : ContentStreamBase.DEFAULT_CHARSET);
            String[] lines = jsonStr.split("\n");
            if (lines.length > 1) {
                for (String line : lines) {
                    if ((line = line.trim()).isEmpty() || !line.startsWith("{") || !line.endsWith("}")) continue;
                    isJsonLines = true;
                    break;
                }
            }
            docs = isJsonLines ? this.loadJsonLines(lines) : Collections.singletonList((Map)json);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected one or more JSON docs in the request body!");
        }
        if (maxDocsToLoad > 0 && docs.size() > maxDocsToLoad) {
            docs = docs.subList(0, maxDocsToLoad);
        }
        return docs.stream().map(JsonLoader::buildDoc).collect(Collectors.toList());
    }

    protected List<SolrInputDocument> loadXmlDocs(SolrParams params, ContentStreamBase.ByteArrayStream stream, int maxDocsToLoad) throws IOException {
        Document xmlDoc;
        List<SolrInputDocument> docs;
        String xmlString = this.readInputAsString(stream.getStream()).trim();
        if (xmlString.contains("<add>") && xmlString.contains("<doc>")) {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader parser = null;
            try {
                parser = inputFactory.createXMLStreamReader(new StringReader(xmlString));
                docs = this.parseXmlDocs(parser, maxDocsToLoad);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
        }
        try {
            xmlDoc = SafeXMLParsing.parseUntrustedXML(log, xmlString);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        Element root = xmlDoc.getDocumentElement();
        throw new IOException("TODO: XML documents with root " + root.getTagName() + " not supported yet!");
        return docs;
    }

    protected List<SolrInputDocument> parseXmlDocs(XMLStreamReader parser, int maxDocsToLoad) throws XMLStreamException {
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        XMLLoader loader = new XMLLoader().init(null);
        block6: while (true) {
            int event;
            try {
                event = parser.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                return docs;
            }
            switch (event) {
                case 8: {
                    parser.close();
                    return docs;
                }
                case 1: {
                    SolrInputDocument doc;
                    if (!"doc".equals(parser.getLocalName()) || (doc = loader.readDoc(parser)) == null) continue block6;
                    docs.add(doc);
                    if (maxDocsToLoad <= 0 || docs.size() < maxDocsToLoad) continue block6;
                    parser.close();
                    return docs;
                }
            }
        }
    }

    protected List<Map<String, Object>> loadJsonLines(String[] lines) throws IOException {
        ArrayList<Map<String, Object>> docs = new ArrayList<Map<String, Object>>(lines.length);
        for (String line : lines) {
            Object jsonLine;
            if ((line = line.trim()).isEmpty() || !line.startsWith("{") || !line.endsWith("}") || !((jsonLine = ObjectBuilder.getVal(new JSONParser(line))) instanceof Map)) continue;
            docs.add((Map)jsonLine);
        }
        return docs;
    }

    protected String readInputAsString(InputStream in) throws IOException {
        return new String(DefaultSampleDocumentsLoader.streamAsBytes(in), StandardCharsets.UTF_8);
    }

    protected char detectTSV(String csvStr) {
        int sep = 44;
        int endOfFirstLine = csvStr.indexOf(10);
        if (endOfFirstLine != -1) {
            int commas = 0;
            int tabs = 0;
            for (char value : csvStr.substring(0, endOfFirstLine).toCharArray()) {
                if (value == ',') {
                    ++commas;
                    continue;
                }
                if (value != '\t') continue;
                ++tabs;
            }
            if (tabs >= commas) {
                sep = 9;
            }
        }
        return (char)sep;
    }

    private static class SampleCSVLoader
    extends CSVLoaderBase {
        List<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        CSVRequest req;
        int maxDocsToLoad;
        String multiValueDelimiter;

        SampleCSVLoader(CSVRequest req, int maxDocsToLoad) {
            super(req, new NoOpUpdateRequestProcessor());
            this.req = req;
            this.maxDocsToLoad = maxDocsToLoad;
            this.multiValueDelimiter = req.getParams().get(DefaultSampleDocumentsLoader.CSV_MULTI_VALUE_DELIM_PARAM);
        }

        List<SolrInputDocument> loadDocs(ContentStream stream) throws IOException {
            this.load(this.req, new SolrQueryResponse(), stream, this.processor);
            return this.docs;
        }

        @Override
        public void addDoc(int line, String[] vals) throws IOException {
            if (this.maxDocsToLoad > 0 && this.docs.size() >= this.maxDocsToLoad) {
                return;
            }
            this.templateAdd.clear();
            SolrInputDocument doc = new SolrInputDocument();
            this.doAdd(line, vals, doc, this.templateAdd);
            if (this.templateAdd.solrDoc != null) {
                if (this.multiValueDelimiter != null) {
                    for (SolrInputField field : this.templateAdd.solrDoc.values()) {
                        String[] splitValue;
                        Object value;
                        if (field.getValueCount() != 1 || !((value = field.getFirstValue()) instanceof String) || (splitValue = ((String)value).split(this.multiValueDelimiter)).length <= 1) continue;
                        field.setValue(Arrays.asList(splitValue));
                    }
                }
                this.docs.add(this.templateAdd.solrDoc);
            }
        }
    }

    private static class CSVRequest
    extends SolrQueryRequestBase {
        CSVRequest(SolrParams params) {
            super(null, params);
        }
    }

    private static class NoOpUpdateRequestProcessor
    extends UpdateRequestProcessor {
        NoOpUpdateRequestProcessor() {
            super(null);
        }
    }
}

