/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLLoader
extends ContentStreamLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicBoolean WARNED_ABOUT_INDEX_TIME_BOOSTS = new AtomicBoolean();
    protected static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    protected XMLInputFactory inputFactory;
    protected SAXParserFactory saxFactory;

    @Override
    public XMLLoader init(SolrParams args) {
        this.inputFactory = XMLInputFactory.newInstance();
        EmptyEntityResolver.configureXMLInputFactory(this.inputFactory);
        this.inputFactory.setXMLReporter(xmllog);
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input chain: {}", (Object)this.inputFactory);
        }
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        EmptyEntityResolver.configureSAXParserFactory(this.saxFactory);
        return this;
    }

    @Override
    public String getDefaultWT() {
        return "xml";
    }

    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        String charset = ContentStreamBase.getCharsetFromContentType(stream.getContentType());
        try (XMLStreamReader parser = null;
             InputStream is = this.getStream(stream, charset);){
            parser = charset == null ? this.inputFactory.createXMLStreamReader(is) : this.inputFactory.createXMLStreamReader(is, charset);
            this.processUpdate(req, processor, parser);
        }
    }

    private InputStream getStream(ContentStream cs, String charset) throws IOException {
        if (log.isTraceEnabled()) {
            try (InputStream is = cs.getStream();){
                byte[] body = is.readAllBytes();
                if (log.isTraceEnabled()) {
                    log.trace("body: {}", (Object)new String(body, charset == null ? ContentStreamBase.DEFAULT_CHARSET : charset));
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
                return byteArrayInputStream;
            }
        }
        return cs.getStream();
    }

    protected void processUpdate(SolrQueryRequest req, UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException, FactoryConfigurationError {
        AddUpdateCommand addCmd = null;
        SolrParams params = req.getParams();
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return;
                }
                case 1: {
                    String currTag = parser.getLocalName();
                    if (currTag.equals("add")) {
                        log.trace("SolrCore.update(add)");
                        addCmd = new AddUpdateCommand(req);
                        addCmd.commitWithin = params.getInt("commitWithin", -1);
                        addCmd.overwrite = params.getBool("overwrite", true);
                        int i = 0;
                        while (true) {
                            if (i >= parser.getAttributeCount()) continue block4;
                            String attrName = parser.getAttributeLocalName(i);
                            String attrVal = parser.getAttributeValue(i);
                            if ("overwrite".equals(attrName)) {
                                addCmd.overwrite = StrUtils.parseBoolean(attrVal);
                            } else if ("commitWithin".equals(attrName)) {
                                addCmd.commitWithin = Integer.parseInt(attrVal);
                            } else {
                                log.warn("XML element <add> has invalid XML attr: {}", (Object)attrName);
                            }
                            ++i;
                        }
                    }
                    if ("doc".equals(currTag)) {
                        if (addCmd != null) {
                            log.trace("adding doc...");
                            addCmd.clear();
                            addCmd.solrDoc = this.readDoc(parser);
                            processor.processAdd(addCmd);
                            break;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected <doc> tag without an <add> tag surrounding it.");
                    }
                    if ("commit".equals(currTag) || "optimize".equals(currTag)) {
                        log.trace("parsing {}", (Object)currTag);
                        CommitUpdateCommand cmd = new CommitUpdateCommand(req, "optimize".equals(currTag));
                        ModifiableSolrParams mp = new ModifiableSolrParams();
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            String attrName = parser.getAttributeLocalName(i);
                            String attrVal = parser.getAttributeValue(i);
                            mp.set(attrName, attrVal);
                        }
                        RequestHandlerUtils.validateCommitParams(mp);
                        SolrParams p = SolrParams.wrapDefaults(mp, req.getParams());
                        RequestHandlerUtils.updateCommit(cmd, p);
                        processor.processCommit(cmd);
                        break;
                    }
                    if ("rollback".equals(currTag)) {
                        log.trace("parsing rollback");
                        RollbackUpdateCommand cmd = new RollbackUpdateCommand(req);
                        processor.processRollback(cmd);
                        break;
                    }
                    if (!"delete".equals(currTag)) break;
                    log.trace("parsing delete");
                    this.processDelete(req, processor, parser);
                }
            }
        }
    }

    void processDelete(SolrQueryRequest req, UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException {
        DeleteUpdateCommand deleteCmd = new DeleteUpdateCommand(req);
        SolrParams params = req.getParams();
        deleteCmd.commitWithin = params.getInt("commitWithin", -1);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName = parser.getAttributeLocalName(i);
            String attrVal = parser.getAttributeValue(i);
            if ("fromPending".equals(attrName) || "fromCommitted".equals(attrName)) continue;
            if ("commitWithin".equals(attrName)) {
                deleteCmd.commitWithin = Integer.parseInt(attrVal);
                continue;
            }
            log.warn("XML element <delete> has invalid XML attr: {}", (Object)attrName);
        }
        StringBuilder text = new StringBuilder();
        block6: while (true) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    String mode = parser.getLocalName();
                    if (!"id".equals(mode) && !"query".equals(mode)) {
                        String msg = "XML element <delete> has invalid XML child element: " + mode;
                        log.warn(msg);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                    }
                    text.setLength(0);
                    if (!"id".equals(mode)) break;
                    int i = 0;
                    while (true) {
                        if (i >= parser.getAttributeCount()) continue block6;
                        String attrName = parser.getAttributeLocalName(i);
                        String attrVal = parser.getAttributeValue(i);
                        if ("version".equals(attrName)) {
                            deleteCmd.setVersion(Long.parseLong(attrVal));
                        }
                        if ("_route_".equals(attrName)) {
                            deleteCmd.setRoute(attrVal);
                        }
                        ++i;
                    }
                }
                case 2: {
                    String currTag = parser.getLocalName();
                    if ("id".equals(currTag)) {
                        deleteCmd.setId(text.toString());
                    } else if ("query".equals(currTag)) {
                        deleteCmd.setQuery(text.toString());
                    } else {
                        if ("delete".equals(currTag)) {
                            return;
                        }
                        String msg = "XML element <delete> has invalid XML (closing) child element: " + currTag;
                        log.warn(msg);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                    }
                    processor.processDelete(deleteCmd);
                    deleteCmd.clear();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                }
            }
        }
    }

    public SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        return this.readDoc(parser, false);
    }

    protected SolrInputDocument readDoc(XMLStreamReader parser, boolean forgiveNameAttr) throws XMLStreamException {
        String attrName;
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrName = parser.getAttributeLocalName(i);
            if ("boost".equals(attrName)) {
                String message = "Ignoring document boost: " + parser.getAttributeValue(i) + " as index-time boosts are not supported anymore";
                if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                    log.warn(message);
                    continue;
                }
                log.debug(message);
                continue;
            }
            if ("name".equals(attrName) && forgiveNameAttr) continue;
            log.warn("XML element <doc> has invalid XML attr: {}", (Object)attrName);
        }
        StringBuilder text = new StringBuilder();
        String currentFieldName = null;
        boolean isNull = false;
        boolean isLabeledChildDoc = false;
        String update = null;
        ArrayList<SolrInputDocument> subDocs = null;
        HashMap<String, Map> updateMap = null;
        boolean complete = false;
        while (!complete) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    String v;
                    if ("doc".equals(parser.getLocalName())) {
                        if (subDocs != null && !subDocs.isEmpty()) {
                            doc.addChildDocuments((Collection<SolrInputDocument>)subDocs);
                            subDocs = null;
                        }
                        complete = true;
                        break;
                    }
                    if (!"field".equals(parser.getLocalName())) break;
                    String string = v = isNull ? null : text.toString();
                    if (update != null) {
                        Map extendedValues;
                        Object val;
                        if (updateMap == null) {
                            updateMap = new HashMap<String, Map>();
                        }
                        if ((val = (extendedValues = updateMap.computeIfAbsent(currentFieldName, k -> CollectionUtil.newHashMap(1))).get(update)) == null) {
                            extendedValues.put(update, v);
                            break;
                        }
                        if (val instanceof List) {
                            List list = (List)val;
                            list.add(v);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(val);
                        values.add(v);
                        extendedValues.put(update, values);
                        break;
                    }
                    if (!isLabeledChildDoc) {
                        doc.addField(currentFieldName, v);
                    } else {
                        isLabeledChildDoc = false;
                    }
                    currentFieldName = null;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if ("doc".equals(localName)) {
                        if (currentFieldName != null) {
                            isLabeledChildDoc = true;
                            SolrInputDocument child = this.readDoc(parser);
                            if (doc.containsKey(currentFieldName)) {
                                doc.getField(currentFieldName).addValue(child);
                                break;
                            }
                            ArrayList<SolrInputDocument> list = new ArrayList<SolrInputDocument>(List.of(child));
                            doc.addField(currentFieldName, list);
                            break;
                        }
                        String subdocName = parser.getAttributeValue(null, "name");
                        if (subdocName != null) {
                            doc.addField(subdocName, this.readDoc(parser, true));
                            break;
                        }
                        if (subDocs == null) {
                            subDocs = new ArrayList<SolrInputDocument>();
                        }
                        subDocs.add(this.readDoc(parser));
                        break;
                    }
                    if (!"field".equals(localName)) {
                        String msg = "XML element <doc> has invalid XML child element: " + localName;
                        log.warn(msg);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                    }
                    update = null;
                    isNull = false;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        String attrVal = parser.getAttributeValue(i);
                        if ("name".equals(attrName)) {
                            currentFieldName = attrVal;
                            continue;
                        }
                        if ("boost".equals(attrName)) {
                            String message = "Ignoring field boost: " + attrVal + " as index-time boosts are not supported anymore";
                            if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                                log.warn(message);
                                continue;
                            }
                            log.debug(message);
                            continue;
                        }
                        if ("null".equals(attrName)) {
                            isNull = StrUtils.parseBoolean(attrVal);
                            continue;
                        }
                        if ("update".equals(attrName)) {
                            update = attrVal;
                            continue;
                        }
                        log.warn("XML element <field> has invalid XML attr: {}", (Object)attrName);
                    }
                    break;
                }
            }
        }
        if (updateMap != null) {
            for (Map.Entry entry : updateMap.entrySet()) {
                doc.addField((String)entry.getKey(), entry.getValue());
            }
        }
        return doc;
    }
}

