/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.legacy;

import java.util.Objects;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.legacy.LegacyNumericUtils;

@Deprecated
public final class LegacyNumericTokenStream
extends TokenStream {
    public static final String TOKEN_TYPE_FULL_PREC = "fullPrecNumeric";
    public static final String TOKEN_TYPE_LOWER_PREC = "lowerPrecNumeric";
    private final LegacyNumericTermAttribute numericAtt = this.addAttribute(LegacyNumericTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int valSize = 0;
    private final int precisionStep;

    public LegacyNumericTokenStream() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, 16);
    }

    public LegacyNumericTokenStream(int precisionStep) {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, precisionStep);
    }

    public LegacyNumericTokenStream(AttributeFactory factory, int precisionStep) {
        super(new NumericAttributeFactory(factory));
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = precisionStep;
        this.numericAtt.setShift(-precisionStep);
    }

    public LegacyNumericTokenStream setLongValue(long value) {
        this.valSize = 64;
        this.numericAtt.init(value, 64, this.precisionStep, -this.precisionStep);
        return this;
    }

    public LegacyNumericTokenStream setIntValue(int value) {
        this.valSize = 32;
        this.numericAtt.init(value, 32, this.precisionStep, -this.precisionStep);
        return this;
    }

    public LegacyNumericTokenStream setDoubleValue(double value) {
        this.valSize = 64;
        this.numericAtt.init(NumericUtils.doubleToSortableLong(value), 64, this.precisionStep, -this.precisionStep);
        return this;
    }

    public LegacyNumericTokenStream setFloatValue(float value) {
        this.valSize = 32;
        this.numericAtt.init(NumericUtils.floatToSortableInt(value), 32, this.precisionStep, -this.precisionStep);
        return this;
    }

    @Override
    public void reset() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
        this.numericAtt.setShift(-this.precisionStep);
    }

    @Override
    public boolean incrementToken() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
        this.clearAttributes();
        int shift = this.numericAtt.incShift();
        this.typeAtt.setType(shift == 0 ? TOKEN_TYPE_FULL_PREC : TOKEN_TYPE_LOWER_PREC);
        this.posIncrAtt.setPositionIncrement(shift == 0 ? 1 : 0);
        return shift < this.valSize;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(precisionStep=" + this.precisionStep + " valueSize=" + this.numericAtt.getValueSize() + " shift=" + this.numericAtt.getShift() + ")";
    }

    public static final class LegacyNumericTermAttributeImpl
    extends AttributeImpl
    implements LegacyNumericTermAttribute,
    TermToBytesRefAttribute {
        private long value = 0L;
        private int valueSize = 0;
        private int shift = 0;
        private int precisionStep = 0;
        private BytesRefBuilder bytes = new BytesRefBuilder();

        @Override
        public BytesRef getBytesRef() {
            assert (this.valueSize == 64 || this.valueSize == 32);
            if (this.shift >= this.valueSize) {
                this.bytes.clear();
            } else if (this.valueSize == 64) {
                LegacyNumericUtils.longToPrefixCoded(this.value, this.shift, this.bytes);
            } else {
                LegacyNumericUtils.intToPrefixCoded((int)this.value, this.shift, this.bytes);
            }
            return this.bytes.get();
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public void setShift(int shift) {
            this.shift = shift;
        }

        @Override
        public int incShift() {
            return this.shift += this.precisionStep;
        }

        @Override
        public long getRawValue() {
            return this.value & ((1L << this.shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public int getValueSize() {
            return this.valueSize;
        }

        @Override
        public void init(long value, int valueSize, int precisionStep, int shift) {
            this.value = value;
            this.valueSize = valueSize;
            this.precisionStep = precisionStep;
            this.shift = shift;
        }

        @Override
        public void clear() {
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
            reflector.reflect(LegacyNumericTermAttribute.class, "shift", this.shift);
            reflector.reflect(LegacyNumericTermAttribute.class, "rawValue", this.getRawValue());
            reflector.reflect(LegacyNumericTermAttribute.class, "valueSize", this.valueSize);
        }

        @Override
        public void copyTo(AttributeImpl target) {
            LegacyNumericTermAttribute a = (LegacyNumericTermAttribute)((Object)target);
            a.init(this.value, this.valueSize, this.precisionStep, this.shift);
        }

        @Override
        public LegacyNumericTermAttributeImpl clone() {
            LegacyNumericTermAttributeImpl t = (LegacyNumericTermAttributeImpl)super.clone();
            t.bytes = new BytesRefBuilder();
            t.bytes.copyBytes(this.getBytesRef());
            return t;
        }

        public int hashCode() {
            return Objects.hash(this.precisionStep, this.shift, this.value, this.valueSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LegacyNumericTermAttributeImpl)) {
                return false;
            }
            LegacyNumericTermAttributeImpl other = (LegacyNumericTermAttributeImpl)obj;
            if (this.precisionStep != other.precisionStep) {
                return false;
            }
            if (this.shift != other.shift) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            return this.valueSize == other.valueSize;
        }
    }

    private static final class NumericAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        NumericAttributeFactory(AttributeFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("LegacyNumericTokenStream does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(attClass);
        }
    }

    public static interface LegacyNumericTermAttribute
    extends Attribute {
        public int getShift();

        public long getRawValue();

        public int getValueSize();

        public void init(long var1, int var3, int var4, int var5);

        public void setShift(int var1);

        public int incShift();
    }
}

