/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging.jul;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.logging.jul.JulInfo;
import org.apache.solr.logging.jul.RecordHandler;

@SuppressForbidden(reason="class is specific to java.util.logging")
public class JulWatcher
extends LogWatcher<LogRecord> {
    final String name;
    RecordHandler handler = null;

    public JulWatcher(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return "JUL (" + this.name + ")";
    }

    @Override
    public List<String> getAllLevels() {
        return Arrays.asList(Level.FINEST.getName(), Level.FINER.getName(), Level.FINE.getName(), Level.CONFIG.getName(), Level.INFO.getName(), Level.WARNING.getName(), Level.SEVERE.getName(), Level.OFF.getName());
    }

    @Override
    public void setLogLevel(String category, String level) {
        if ("root".equals(category)) {
            category = "";
        }
        Logger log = LogManager.getLogManager().getLogger(category);
        if (level == null || "unset".equals(level) || "null".equals(level)) {
            if (log != null) {
                log.setLevel(null);
            }
        } else {
            if (log == null) {
                log = Logger.getLogger(category);
            }
            log.setLevel(Level.parse(level));
        }
    }

    @Override
    public Collection<LoggerInfo> getAllLoggers() {
        LogManager manager = LogManager.getLogManager();
        Logger root = manager.getLogger("");
        HashMap<String, JulInfo> map = new HashMap<String, JulInfo>();
        Enumeration<String> names = manager.getLoggerNames();
        while (names.hasMoreElements()) {
            int dot;
            String name = names.nextElement();
            Logger logger = Logger.getLogger(name);
            if (logger == root) continue;
            map.put(name, new JulInfo(name, logger));
            while ((dot = name.lastIndexOf(46)) >= 0) {
                if (map.containsKey(name = name.substring(0, dot))) continue;
                map.put(name, new JulInfo(name, null));
            }
        }
        map.put("root", new JulInfo("root", root));
        return map.values();
    }

    @Override
    public void setThreshold(String level) {
        if (this.handler == null) {
            throw new IllegalStateException("Must have an handler");
        }
        this.handler.setLevel(Level.parse(level));
    }

    @Override
    public String getThreshold() {
        if (this.handler == null) {
            throw new IllegalStateException("Must have an handler");
        }
        return this.handler.getLevel().toString();
    }

    @Override
    public void registerListener(ListenerConfig cfg) {
        if (this.history != null) {
            throw new IllegalStateException("History already registered");
        }
        this.history = new CircularList(cfg.size);
        this.handler = new RecordHandler(this);
        if (cfg.threshold != null) {
            this.handler.setLevel(Level.parse(cfg.threshold));
        } else {
            this.handler.setLevel(Level.WARNING);
        }
        Logger log = LogManager.getLogManager().getLogger("");
        log.addHandler(this.handler);
    }

    @Override
    public SolrDocument toSolrDocument(LogRecord event) {
        SolrDocument doc = new SolrDocument();
        doc.setField("time", new Date(event.getMillis()));
        doc.setField("level", event.getLevel().toString());
        doc.setField("logger", event.getLoggerName());
        doc.setField("message", event.getMessage().toString());
        Throwable t = event.getThrown();
        if (t != null) {
            StringWriter trace = new StringWriter();
            t.printStackTrace(new PrintWriter(trace));
            doc.setField("trace", trace.toString());
        }
        return doc;
    }
}

