/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsMap
implements Gauge<Map<String, Object>>,
MapWriter,
DynamicMBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean useCachedStatsBetweenGetMBeanInfoCalls = Boolean.getBoolean("useCachedStatsBetweenGetMBeanInfoCalls");
    private BiConsumer<Boolean, Map<String, Object>> mapInitializer;
    private MapWriter initializer;
    private Map<String, String> jmxAttributes;
    private volatile Map<String, Object> cachedValue;

    public MetricsMap(MapWriter initializer) {
        this.initializer = initializer;
    }

    public Map<String, Object> getValue() {
        return this.getValue(true);
    }

    public Map<String, Object> getValue(boolean detailed) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.mapInitializer != null) {
            this.mapInitializer.accept(detailed, map);
        } else {
            this.initializer.toMap(map);
        }
        return map;
    }

    public String toString() {
        return this.getValue().toString();
    }

    private synchronized void initJmxAttributes() {
        if (this.jmxAttributes == null) {
            this.jmxAttributes = new HashMap<String, String>();
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Map<String, Object> cachedStats;
        String val;
        if (this.jmxAttributes != null && (val = this.jmxAttributes.get(attribute)) != null) {
            return val;
        }
        Map<String, Object> stats = null;
        if (this.useCachedStatsBetweenGetMBeanInfoCalls && (cachedStats = this.cachedValue) != null) {
            stats = cachedStats;
        }
        if (stats == null) {
            stats = this.getValue(true);
        }
        if ((val = stats.get(attribute)) != null) {
            for (String simpleTypeName : SimpleType.ALLOWED_CLASSNAMES_LIST) {
                if (!val.getClass().getName().equals(simpleTypeName)) continue;
                return val;
            }
            return val.toString();
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.initJmxAttributes();
        this.jmxAttributes.put(attribute.getName(), String.valueOf(attribute.getValue()));
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                log.warn("Could not get attribute {}", (Object)attribute);
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Operation not Supported");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Operation not Supported");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList attrInfoList;
        block4: {
            attrInfoList = new ArrayList();
            Map<String, Object> stats = this.getValue(true);
            if (this.useCachedStatsBetweenGetMBeanInfoCalls) {
                this.cachedValue = stats;
            }
            if (this.jmxAttributes != null) {
                this.jmxAttributes.forEach((k, v) -> attrInfoList.add(new MBeanAttributeInfo((String)k, String.class.getName(), null, true, false, false)));
            }
            try {
                stats.forEach((k, v) -> {
                    if (this.jmxAttributes != null && this.jmxAttributes.containsKey(k)) {
                        return;
                    }
                    Class<?> type = v.getClass();
                    OpenType<?> typeBox = this.determineType(type);
                    if (type.equals(String.class) || typeBox == null) {
                        attrInfoList.add(new MBeanAttributeInfo((String)k, String.class.getName(), null, true, false, false));
                    } else {
                        attrInfoList.add(new OpenMBeanAttributeInfoSupport((String)k, (String)k, typeBox, true, false, false));
                    }
                });
            }
            catch (Exception e) {
                if (SolrException.getRootCause(e) instanceof AlreadyClosedException) break block4;
                log.warn("Could not get attributes of MetricsMap: {}", (Object)this, (Object)e);
            }
        }
        MBeanAttributeInfo[] attrInfoArr = attrInfoList.toArray(new MBeanAttributeInfo[0]);
        return new MBeanInfo(this.getClass().getName(), "MetricsMap", attrInfoArr, null, null, null);
    }

    private OpenType<?> determineType(Class<?> type) {
        try {
            for (Field field : SimpleType.class.getFields()) {
                SimpleType candidate;
                if (!field.getType().equals(SimpleType.class) || !(candidate = (SimpleType)field.get(SimpleType.class)).getTypeName().equals(type.getName())) continue;
                return candidate;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.mapInitializer != null) {
            Object value = this.getValue();
            value.forEach((k, v) -> ew.putNoEx((CharSequence)k, v));
        } else {
            this.initializer.writeMap(ew);
        }
    }
}

