/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.filestore.DistribFileStore;
import org.apache.solr.filestore.FileStoreAPI;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.util.SolrJacksonAnnotationInspector;

public class PackageUtils {
    public static String LATEST = "latest";
    public static String PACKAGE_PATH = "/api/cluster/package";
    public static String CLUSTER_PLUGINS_PATH = "/api/cluster/plugin";
    public static String REPOSITORIES_ZK_PATH = "/repositories.json";
    public static String CLUSTERPROPS_PATH = "/api/cluster/zk/data/clusterprops.json";
    public static String BLACK = "\u001b[30m";
    public static String RED = "\u001b[31m";
    public static String GREEN = "\u001b[32m";
    public static String YELLOW = "\u001b[33m";
    public static String BLUE = "\u001b[34m";
    public static String PURPLE = "\u001b[35m";
    public static String CYAN = "\u001b[36m";
    public static String WHITE = "\u001b[37m";

    public static Configuration jsonPathConfiguration() {
        JacksonMappingProvider provider = new JacksonMappingProvider();
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
        Configuration c = Configuration.builder().jsonProvider((JsonProvider)jsonProvider).mappingProvider((MappingProvider)provider).options(new Option[]{Option.REQUIRE_PROPERTIES}).build();
        return c;
    }

    public static ObjectMapper getMapper() {
        return new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new SolrJacksonAnnotationInspector());
    }

    public static void postFile(SolrClient client, final ByteBuffer buffer, String name, String sig) throws SolrServerException, IOException {
        GenericSolrRequest request;
        NamedList<Object> rsp;
        String resource = "/api/cluster/files" + name;
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (sig != null) {
            params.add("sig", sig);
        }
        if (!name.equals((rsp = client.request(request = new GenericSolrRequest(SolrRequest.METHOD.PUT, resource, params){

            @Override
            public RequestWriter.ContentWriter getContentWriter(String expectedType) {
                return new RequestWriter.ContentWriter(){
                    public final ByteBuffer payload;
                    {
                        this.payload = buffer;
                    }

                    @Override
                    public void write(OutputStream os) throws IOException {
                        if (this.payload == null) {
                            return;
                        }
                        Channels.newChannel(os).write(this.payload);
                    }

                    @Override
                    public String getContentType() {
                        return "application/octet-stream";
                    }
                };
            }
        })).get("file"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Mismatch in file uploaded. Uploaded: " + rsp.get("file") + ", Original: " + name);
        }
    }

    public static <T> T getJson(SolrClient client, String path, Class<T> klass) {
        try {
            return (T)PackageUtils.getMapper().readValue(PackageUtils.getJsonStringFromUrl(client, path, new ModifiableSolrParams()), klass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileFromJarsAsString(List<Path> jars, String filename) {
        for (Path jarfile : jars) {
            ZipEntry entry;
            ZipFile zipFile;
            block9: {
                zipFile = new ZipFile(jarfile.toFile());
                try {
                    entry = zipFile.getEntry(filename);
                    if (entry != null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ex);
                    }
                }
                zipFile.close();
                continue;
            }
            String string = new String(zipFile.getInputStream(entry).readAllBytes(), StandardCharsets.UTF_8);
            zipFile.close();
            return string;
        }
        return null;
    }

    public static String getJsonStringFromUrl(SolrClient client, String path, SolrParams params) {
        try {
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params);
            request.setResponseParser(new JsonMapResponseParser());
            NamedList<Object> response = client.request(request);
            return response.jsonStr();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    public static SolrPackage.Manifest fetchManifest(SolrClient solrClient, String manifestFilePath, String expectedSHA512) throws IOException, SolrServerException {
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/api/node/files" + manifestFilePath);
        request.setResponseParser(new JsonMapResponseParser());
        NamedList<Object> response = solrClient.request(request);
        String manifestJson = (String)response.get("response");
        String calculatedSHA512 = BlobRepository.sha512Digest(ByteBuffer.wrap(manifestJson.getBytes(StandardCharsets.UTF_8)));
        if (!expectedSHA512.equals(calculatedSHA512)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The manifest SHA512 doesn't match expected SHA512. Possible unauthorized manipulation. Expected: " + expectedSHA512 + ", calculated: " + calculatedSHA512 + ", manifest location: " + manifestFilePath);
        }
        SolrPackage.Manifest manifest = (SolrPackage.Manifest)PackageUtils.getMapper().readValue(manifestJson, SolrPackage.Manifest.class);
        return manifest;
    }

    public static String resolve(String str, Map<String, String> defaults, Map<String, String> overrides, Map<String, String> systemParams) {
        if (str == null) {
            return null;
        }
        if (defaults != null) {
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                String param = entry.getKey();
                str = str.replace("${" + param + "}", overrides.containsKey(param) ? (CharSequence)overrides.get(param) : (CharSequence)entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            str = str.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        for (Map.Entry<String, String> entry : systemParams.entrySet()) {
            str = str.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return str;
    }

    public static void printGreen(Object message) {
        PackageUtils.print(GREEN, message);
    }

    public static void printRed(Object message) {
        PackageUtils.print(RED, message);
    }

    public static void print(Object message) {
        PackageUtils.print(null, message);
    }

    @SuppressForbidden(reason="Need to use System.out.println() instead of log4j/slf4j for cleaner output")
    public static void print(String color, Object message) {
        String RESET = "\u001b[0m";
        if (color != null) {
            System.out.println(color + String.valueOf(message) + RESET);
        } else {
            System.out.println(message);
        }
    }

    public static String[] validateCollections(String[] collections) {
        for (String c : collections) {
            SolrIdentifierValidator.validateCollectionName(c);
        }
        return collections;
    }

    public static String getCollectionParamsPath(String collection) {
        return "/api/collections/" + collection + "/config/params";
    }

    public static void uploadKey(byte[] bytes, String path, Path home) throws IOException {
        FileStoreAPI.MetaData meta = FileStoreAPI._createJsonMetaData(bytes, null);
        DistribFileStore._persistToFile(home, path, ByteBuffer.wrap(bytes), ByteBuffer.wrap(Utils.toJSON(meta)));
    }
}

