/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.client.api.util.SolrVersion;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.beans.PackagePayload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.packagemanager.DefaultPackageRepository;
import org.apache.solr.packagemanager.PackageManager;
import org.apache.solr.packagemanager.PackageRepository;
import org.apache.solr.packagemanager.PackageUtils;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.packagemanager.SolrPackageInstance;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PackageManager packageManager;
    final SolrClient solrClient;

    public RepositoryManager(SolrClient solrClient, PackageManager packageManager) {
        this.packageManager = packageManager;
        this.solrClient = solrClient;
    }

    public List<SolrPackage> getPackages() {
        ArrayList<SolrPackage> list = new ArrayList<SolrPackage>(this.getPackagesMap().values());
        Collections.sort(list);
        return list;
    }

    public Map<String, SolrPackage> getPackagesMap() {
        HashMap<String, SolrPackage> packagesMap = new HashMap<String, SolrPackage>();
        for (PackageRepository repository : this.getRepositories()) {
            packagesMap.putAll(repository.getPackages());
        }
        return packagesMap;
    }

    public List<PackageRepository> getRepositories() {
        PackageRepository[] items;
        try {
            items = (PackageRepository[])PackageUtils.getMapper().readValue(this.getRepositoriesJson(this.packageManager.zkClient), DefaultPackageRepository[].class);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
        }
        List<PackageRepository> repositories = Arrays.asList(items);
        for (PackageRepository updateRepository : repositories) {
            updateRepository.refresh();
        }
        return repositories;
    }

    public void addRepository(String repoName, String uri) throws Exception {
        String existingRepositoriesJson = this.getRepositoriesJson(this.packageManager.zkClient);
        log.info(existingRepositoriesJson);
        List repos = (List)PackageUtils.getMapper().readValue(existingRepositoriesJson, List.class);
        repos.add(new DefaultPackageRepository(repoName, uri));
        if (!this.packageManager.zkClient.exists(PackageUtils.REPOSITORIES_ZK_PATH, true).booleanValue()) {
            this.packageManager.zkClient.create(PackageUtils.REPOSITORIES_ZK_PATH, PackageUtils.getMapper().writeValueAsString((Object)repos).getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, true);
        } else {
            this.packageManager.zkClient.setData(PackageUtils.REPOSITORIES_ZK_PATH, PackageUtils.getMapper().writeValueAsString((Object)repos).getBytes(StandardCharsets.UTF_8), true);
        }
        try (InputStream is = new URL(uri + "/publickey.der").openStream();){
            this.addKey(is.readAllBytes(), repoName + ".der");
        }
    }

    public void addKey(byte[] key, String destinationKeyFilename) throws Exception {
        NamedList<Object> systemInfo = this.solrClient.request(new GenericSolrRequest(SolrRequest.METHOD.GET, "/solr/admin/info/system"));
        String solrHome = (String)systemInfo.get("solr_home");
        String path = "/_trusted_/keys/" + destinationKeyFilename;
        PackageUtils.uploadKey(key, path, Paths.get(solrHome, new String[0]));
        PackageUtils.getJsonStringFromUrl(this.solrClient, "/api/node/files" + path, new ModifiableSolrParams().add("sync", "true"));
    }

    private String getRepositoriesJson(SolrZkClient zkClient) throws UnsupportedEncodingException, KeeperException, InterruptedException {
        if (zkClient.exists(PackageUtils.REPOSITORIES_ZK_PATH, true).booleanValue()) {
            return new String(zkClient.getData(PackageUtils.REPOSITORIES_ZK_PATH, null, null, true), StandardCharsets.UTF_8);
        }
        return "[]";
    }

    private boolean installPackage(String packageName, String version) throws SolrException {
        SolrPackageInstance existingPlugin = this.packageManager.getPackageInstance(packageName, version);
        if (existingPlugin != null && existingPlugin.version.equals(version)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Plugin already installed.");
        }
        SolrPackage.SolrPackageRelease release = this.getPackageRelease(packageName, version);
        List<Path> downloaded = this.downloadPackageArtifacts(packageName, version);
        try {
            String manifestJson;
            PackageUtils.printGreen("Posting manifest...");
            if (release.manifest == null) {
                manifestJson = PackageUtils.getFileFromJarsAsString(downloaded, "manifest.json");
                if (manifestJson == null) {
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No manifest found for package: " + packageName + ", version: " + version);
                }
                release.manifest = (SolrPackage.Manifest)PackageUtils.getMapper().readValue(manifestJson, SolrPackage.Manifest.class);
            }
            manifestJson = PackageUtils.getMapper().writeValueAsString((Object)release.manifest);
            String manifestSHA512 = BlobRepository.sha512Digest(ByteBuffer.wrap(manifestJson.getBytes(StandardCharsets.UTF_8)));
            PackageUtils.postFile(this.solrClient, ByteBuffer.wrap(manifestJson.getBytes(StandardCharsets.UTF_8)), String.format(Locale.ROOT, "/package/%s/%s/%s", packageName, version, "manifest.json"), null);
            PackageUtils.printGreen("Posting artifacts...");
            for (int i = 0; i < release.artifacts.size(); ++i) {
                PackageUtils.postFile(this.solrClient, ByteBuffer.wrap(Files.readAllBytes(downloaded.get(i))), String.format(Locale.ROOT, "/package/%s/%s/%s", packageName, version, downloaded.get(i).getFileName().toString()), release.artifacts.get((int)i).sig);
            }
            PackageUtils.printGreen("Executing Package API to register this package...");
            final PackagePayload.AddVersion add = new PackagePayload.AddVersion();
            add.version = version;
            add.pkg = packageName;
            add.files = downloaded.stream().map(file -> String.format(Locale.ROOT, "/package/%s/%s/%s", packageName, version, file.getFileName().toString())).collect(Collectors.toList());
            add.manifest = "/package/" + packageName + "/" + version + "/manifest.json";
            add.manifestSHA512 = manifestSHA512;
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, PackageUtils.PACKAGE_PATH){

                @Override
                public RequestWriter.ContentWriter getContentWriter(String expectedType) {
                    return new RequestWriter.StringPayloadContentWriter("{add:" + add.jsonStr() + "}", "application/json");
                }
            };
            try {
                NamedList<Object> resp = this.solrClient.request(request);
                PackageUtils.printGreen("Response: " + resp.jsonStr());
            }
            catch (IOException | SolrServerException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return false;
    }

    private List<Path> downloadPackageArtifacts(String packageName, String version) throws SolrException {
        try {
            SolrPackage.SolrPackageRelease release = this.getPackageRelease(packageName, version);
            ArrayList<Path> downloadedPaths = new ArrayList<Path>(release.artifacts.size());
            for (PackageRepository repo : this.getRepositories()) {
                if (!repo.hasPackage(packageName)) continue;
                for (SolrPackage.Artifact art : release.artifacts) {
                    downloadedPaths.add(repo.download(art.url));
                }
                return downloadedPaths;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during download of package " + packageName, (Throwable)e);
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Package not found in any repository.");
    }

    private SolrPackage.SolrPackageRelease getPackageRelease(String packageName, String version) throws SolrException {
        SolrPackage pkg = this.getPackagesMap().get(packageName);
        if (pkg == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Package " + packageName + " not found in any repository");
        }
        if (version == null || PackageUtils.LATEST.equals(version)) {
            return this.getLastPackageRelease(pkg);
        }
        for (SolrPackage.SolrPackageRelease release : pkg.versions) {
            if (SolrVersion.compareVersions(version, release.version) != 0) continue;
            return release;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Package " + packageName + ":" + version + " does not exist in any repository.");
    }

    public SolrPackage.SolrPackageRelease getLastPackageRelease(String packageName) {
        SolrPackage pkg = this.getPackagesMap().get(packageName);
        if (pkg == null) {
            return null;
        }
        return this.getLastPackageRelease(pkg);
    }

    private SolrPackage.SolrPackageRelease getLastPackageRelease(SolrPackage pkg) {
        SolrPackage.SolrPackageRelease latest = null;
        for (SolrPackage.SolrPackageRelease release : pkg.versions) {
            if (latest == null) {
                latest = release;
                continue;
            }
            if (SolrVersion.compareVersions(latest.version, release.version) >= 0) continue;
            latest = release;
        }
        return latest;
    }

    public boolean hasPackageUpdate(String packageName) {
        SolrPackage pkg = this.getPackagesMap().get(packageName);
        if (pkg == null) {
            return false;
        }
        String installedVersion = this.packageManager.getPackageInstance((String)packageName, null).version;
        SolrPackage.SolrPackageRelease last = this.getLastPackageRelease(packageName);
        return last != null && SolrVersion.compareVersions(last.version, installedVersion) > 0;
    }

    public boolean install(String packageName, String version) throws SolrException {
        SolrPackage.SolrPackageRelease pkg = this.getLastPackageRelease(packageName);
        if (pkg == null) {
            PackageUtils.printRed("Package " + packageName + " not found in any repository. Check list of available packages via \"solr package list-available\".");
            return false;
        }
        String latestVersion = pkg.version;
        Map<String, String> collectionsDeployedIn = this.packageManager.getDeployedCollections(packageName);
        List<String> collectionsPeggedToLatest = collectionsDeployedIn.keySet().stream().filter(collection -> ((String)collectionsDeployedIn.get(collection)).equals("$LATEST")).collect(Collectors.toList());
        if (!collectionsPeggedToLatest.isEmpty()) {
            PackageUtils.printGreen("Collections that will be affected (since they are configured to use $LATEST): " + collectionsPeggedToLatest);
        }
        if (version == null || version.equals(PackageUtils.LATEST)) {
            this.installPackage(packageName, latestVersion);
        } else {
            this.installPackage(packageName, version);
        }
        if (!collectionsPeggedToLatest.isEmpty()) {
            SolrPackageInstance updatedPackage = this.packageManager.getPackageInstance(packageName, PackageUtils.LATEST);
            boolean res = this.packageManager.verify(updatedPackage, collectionsPeggedToLatest, false, new String[0]);
            PackageUtils.printGreen("Verifying version " + updatedPackage.version + " on " + collectionsPeggedToLatest + ", result: " + res);
            if (!res) {
                PackageUtils.printRed("Failed verification after deployment");
                return false;
            }
        }
        return true;
    }
}

