/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.internal.csv.CSVPrinter;
import org.apache.solr.internal.csv.CSVStrategy;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TabularResponseWriter;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.ReturnFields;

class CSVWriter
extends TabularResponseWriter {
    static String SEPARATOR = "separator";
    static String ENCAPSULATOR = "encapsulator";
    static String ESCAPE = "escape";
    static String CSV = "csv.";
    static String CSV_SEPARATOR = CSV + SEPARATOR;
    static String CSV_ENCAPSULATOR = CSV + ENCAPSULATOR;
    static String CSV_ESCAPE = CSV + ESCAPE;
    static String MV = CSV + "mv.";
    static String MV_SEPARATOR = MV + SEPARATOR;
    static String MV_ENCAPSULATOR = MV + ENCAPSULATOR;
    static String MV_ESCAPE = MV + ESCAPE;
    static String CSV_NULL = CSV + "null";
    static String CSV_HEADER = CSV + "header";
    static String CSV_NEWLINE = CSV + "newline";
    char[] sharedCSVBuf = new char[8192];
    int pass;
    Map<String, CSVField> csvFields = new LinkedHashMap<String, CSVField>();
    CSVStrategy strategy;
    CSVPrinter printer;
    ResettableFastWriter mvWriter = new ResettableFastWriter();
    String NullValue;
    List<Object> tmpList;

    public CSVWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeResponse() throws IOException {
        SolrParams params = this.req.getParams();
        char delimiter = ',';
        String sep = params.get(CSV_SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid separator:'" + sep + "'");
            }
            delimiter = sep.charAt(0);
        }
        String printerNewline = "\n";
        String nl = params.get(CSV_NEWLINE);
        if (nl != null) {
            if (nl.length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid newline:'" + nl + "'");
            }
            printerNewline = nl;
        }
        String encapsulator = params.get(CSV_ENCAPSULATOR);
        String escape = params.get(CSV_ESCAPE);
        char encapsulatorChar = '\"';
        if (encapsulator != null) {
            if (encapsulator.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid encapsulator:'" + encapsulator + "'");
            }
            encapsulatorChar = encapsulator.charAt(0);
        }
        char escapeChar = CSVStrategy.ESCAPE_DISABLED;
        if (escape != null) {
            if (escape.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid escape:'" + escape + "'");
            }
            escapeChar = escape.charAt(0);
            if (encapsulator == null) {
                encapsulatorChar = CSVStrategy.ENCAPSULATOR_DISABLED;
            }
        }
        boolean interpretUnicodeEscapes = false;
        if (escapeChar == '\\') {
            interpretUnicodeEscapes = true;
        }
        this.strategy = new CSVStrategy(delimiter, encapsulatorChar, CSVStrategy.COMMENTS_DISABLED, escapeChar, false, false, interpretUnicodeEscapes, true, printerNewline);
        this.printer = new CSVPrinter(this.writer, this.strategy);
        char mvStrategyDelimiter = this.strategy.getDelimiter();
        sep = params.get(MV_SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv separator:'" + sep + "'");
            }
            mvStrategyDelimiter = sep.charAt(0);
        }
        encapsulator = params.get(MV_ENCAPSULATOR);
        escape = params.get(MV_ESCAPE);
        char mvStrategyEncapsulatorChar = CSVStrategy.ENCAPSULATOR_DISABLED;
        char mvStrategyEscape = '\\';
        if (encapsulator != null) {
            if (encapsulator.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv encapsulator:'" + encapsulator + "'");
            }
            mvStrategyEncapsulatorChar = encapsulator.charAt(0);
            if (escape == null) {
                mvStrategyEscape = CSVStrategy.ESCAPE_DISABLED;
            }
        }
        if ((escape = params.get(MV_ESCAPE)) != null) {
            if (escape.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv escape:'" + escape + "'");
            }
            mvStrategyEscape = escape.charAt(0);
        }
        CSVStrategy mvStrategy = new CSVStrategy(mvStrategyDelimiter, mvStrategyEncapsulatorChar, CSVStrategy.COMMENTS_DISABLED, mvStrategyEscape, false, false, false, false, "\n");
        Collection<String> fields = this.getFields();
        CSVSharedBufPrinter csvPrinterMV = new CSVSharedBufPrinter(this.mvWriter, mvStrategy);
        for (String field : fields) {
            if (!this.returnFields.wantsField(field)) continue;
            if (field.equals("score")) {
                CSVField csvField = new CSVField();
                csvField.name = "score";
                this.csvFields.put("score", csvField);
                continue;
            }
            if (this.shouldSkipField(field)) continue;
            SchemaField sf = this.schema.getFieldOrNull(field);
            if (sf == null) {
                StrField ft = new StrField();
                sf = new SchemaField(field, ft);
            }
            sep = params.get("f." + field + "." + CSV_SEPARATOR);
            encapsulator = params.get("f." + field + "." + CSV_ENCAPSULATOR);
            escape = params.get("f." + field + "." + CSV_ESCAPE);
            if (sf.isPolyField()) {
                escape = escape == null ? "\\" : escape;
            }
            CSVSharedBufPrinter csvPrinter = csvPrinterMV;
            if (sep != null || encapsulator != null || escape != null) {
                char fDelimiter = mvStrategy.getDelimiter();
                char fEncapsulator = mvStrategy.getEncapsulator();
                char fEscape = mvStrategy.getEscape();
                if (sep != null) {
                    if (sep.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv separator:'" + sep + "'");
                    }
                    fDelimiter = sep.charAt(0);
                }
                if (encapsulator != null) {
                    if (encapsulator.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv encapsulator:'" + encapsulator + "'");
                    }
                    fEncapsulator = encapsulator.charAt(0);
                    if (escape == null) {
                        fEscape = CSVStrategy.ESCAPE_DISABLED;
                    }
                }
                if (escape != null) {
                    if (escape.length() != 1) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid mv escape:'" + escape + "'");
                    }
                    fEscape = escape.charAt(0);
                    if (encapsulator == null) {
                        fEncapsulator = CSVStrategy.ENCAPSULATOR_DISABLED;
                    }
                }
                CSVStrategy strat = new CSVStrategy(fDelimiter, fEncapsulator, mvStrategy.getCommentStart(), fEscape, mvStrategy.getIgnoreLeadingWhitespaces(), mvStrategy.getIgnoreTrailingWhitespaces(), mvStrategy.getUnicodeEscapeInterpretation(), mvStrategy.getIgnoreEmptyLines(), mvStrategy.getPrinterNewline());
                csvPrinter = new CSVSharedBufPrinter(this.mvWriter, strat);
            }
            CSVField csvField = new CSVField();
            csvField.name = field;
            csvField.sf = sf;
            csvField.mvPrinter = csvPrinter;
            this.csvFields.put(field, csvField);
        }
        this.NullValue = params.get(CSV_NULL, "");
        if (params.getBool(CSV_HEADER, true)) {
            for (CSVField csvField : this.csvFields.values()) {
                this.printer.print(csvField.name);
            }
            this.printer.println();
        }
        this.writeResponse(this.rsp.getResponse());
    }

    @Override
    public void close() throws IOException {
        if (this.printer != null) {
            this.printer.flush();
        }
        super.close();
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<Object>(1);
            this.tmpList.add(null);
        }
        for (CSVField csvField : this.csvFields.values()) {
            List<Object> values;
            int nVals;
            Object val = doc.getFieldValue(csvField.name);
            int n = val instanceof Collection ? ((Collection)val).size() : (nVals = val == null ? 0 : 1);
            if (nVals == 0) {
                this.writeNull(csvField.name);
                continue;
            }
            if (csvField.sf != null && csvField.sf.multiValued() || nVals > 1) {
                if (val instanceof Collection) {
                    values = (List<Object>)val;
                } else {
                    this.tmpList.set(0, val);
                    values = this.tmpList;
                }
                this.mvWriter.reset();
                csvField.mvPrinter.reset();
                CSVPrinter tmp = this.printer;
                this.printer = csvField.mvPrinter;
                for (Object e : values) {
                    this.writeVal(csvField.name, e);
                }
                this.printer = tmp;
                this.mvWriter.freeze();
                this.printer.print(this.mvWriter.getFrozenBuf(), 0, this.mvWriter.getFrozenSize(), true);
                continue;
            }
            if (val instanceof Collection) {
                values = (Collection)val;
                val = values.iterator().next();
            }
            if (csvField.sf != null && csvField.sf.isPolyField()) {
                this.mvWriter.reset();
                csvField.mvPrinter.reset();
                CSVPrinter tmp = this.printer;
                this.printer = csvField.mvPrinter;
                this.writeVal(csvField.name, val);
                this.printer = tmp;
                this.mvWriter.freeze();
                this.printer.print(this.mvWriter.getFrozenBuf(), 0, this.mvWriter.getFrozenSize(), true);
                continue;
            }
            this.writeVal(csvField.name, val);
        }
        this.printer.println();
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.printer.print(val, needsEscaping);
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.printer.print(this.NullValue);
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    @Override
    public void writeDate(String name, String val) throws IOException {
        this.printer.print(val, false);
    }

    static class CSVField {
        String name;
        SchemaField sf;
        CSVSharedBufPrinter mvPrinter;
        List<IndexableField> values = new ArrayList<IndexableField>(1);
        int tmp;

        CSVField() {
        }
    }

    static class ResettableFastWriter
    extends FastWriter {
        OpenCharArrayWriter cw = (OpenCharArrayWriter)this.sink;
        char[] result;
        int resultLen;

        public ResettableFastWriter() {
            super(new OpenCharArrayWriter());
        }

        public void reset() {
            this.cw.reset();
            this.pos = 0;
        }

        public void freeze() throws IOException {
            if (this.cw.size() > 0) {
                this.flush();
                this.result = this.cw.getInternalBuf();
                this.resultLen = this.cw.size();
            } else {
                this.result = this.buf;
                this.resultLen = this.pos;
            }
        }

        public int getFrozenSize() {
            return this.resultLen;
        }

        public char[] getFrozenBuf() {
            return this.result;
        }
    }

    static class OpenCharArrayWriter
    extends CharArrayWriter {
        OpenCharArrayWriter() {
        }

        public char[] getInternalBuf() {
            return this.buf;
        }
    }

    class CSVSharedBufPrinter
    extends CSVPrinter {
        public CSVSharedBufPrinter(Writer out, CSVStrategy strategy) {
            super(out, strategy);
            this.buf = CSVWriter.this.sharedCSVBuf;
        }

        public void reset() {
            this.newLine = true;
            CSVWriter.this.sharedCSVBuf = this.buf;
        }
    }
}

