/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;

public abstract class TabularResponseWriter
extends TextResponseWriter {
    private boolean returnStoredOrDocValStored;

    public TabularResponseWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse resp) {
        super(writer, req, resp);
        this.returnStoredOrDocValStored = this.returnFields.getRequestedFieldNames() == null || this.returnFields.hasPatternMatching();
    }

    public Collection<String> getFields() {
        Set<String> fields = this.returnFields.getRequestedFieldNames();
        Set<String> explicitReqFields = this.returnFields.getExplicitlyRequestedFieldNames();
        Object responseObj = this.rsp.getResponse();
        if (fields == null || this.returnFields.hasPatternMatching()) {
            if (responseObj instanceof SolrDocumentList) {
                if (fields == null) {
                    fields = new LinkedHashSet<String>();
                }
                for (SolrDocument sdoc : (SolrDocumentList)responseObj) {
                    fields.addAll(sdoc.getFieldNames());
                }
            } else {
                Iterable<String> all = this.req.getSearcher().getFieldNames();
                Set allSet = StreamSupport.stream(all.spliterator(), false).collect(Collectors.toSet());
                if (fields == null) {
                    fields = allSet;
                } else {
                    fields.addAll(allSet);
                }
            }
            if (explicitReqFields != null) {
                fields.addAll(explicitReqFields);
            }
            if (this.returnFields.wantsScore()) {
                fields.add("score");
            } else {
                fields.remove("score");
            }
        }
        return fields;
    }

    public boolean shouldSkipField(String field) {
        Set<String> explicitReqFields = this.returnFields.getExplicitlyRequestedFieldNames();
        SchemaField sf = this.schema.getFieldOrNull(field);
        return !(!this.returnStoredOrDocValStored || explicitReqFields != null && explicitReqFields.contains(field) || sf == null || sf.stored() || sf.hasDocValues() && sf.useDocValuesAsStored());
    }

    public void writeResponse(Object responseObj) throws IOException {
        if (responseObj instanceof ResultContext) {
            this.writeDocuments(null, (ResultContext)responseObj);
        } else if (responseObj instanceof DocList) {
            BasicResultContext ctx = new BasicResultContext((DocList)responseObj, this.returnFields, null, null, this.req);
            this.writeDocuments(null, ctx);
        } else if (responseObj instanceof SolrDocumentList) {
            this.writeSolrDocumentList(null, (SolrDocumentList)responseObj, this.returnFields);
        }
    }

    @Override
    public void writeNamedList(String name, NamedList<?> val) throws IOException {
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
    }

    @Override
    public void writeEndDocumentList() throws IOException {
    }

    @Override
    public void writeMap(String name, Map<?, ?> val, boolean excludeOuter, boolean isFirstVal) {
    }

    @Override
    public void writeArray(String name, Iterator<?> val, boolean raw) throws IOException {
    }

    @Override
    public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, val.toInstant().toString());
    }
}

