/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.transform.DocTransformer;

public class RenameFieldTransformer
extends DocTransformer {
    final String from;
    final String to;
    final boolean copy;
    final String[] ensureFromFieldPresent;

    public RenameFieldTransformer(String from, String to, boolean copy) {
        this.from = from;
        this.to = to;
        this.copy = copy;
        this.ensureFromFieldPresent = new String[]{from};
        assert (!from.equals(to));
    }

    @Override
    public String getName() {
        return "Rename[" + this.from + ">>" + this.to + "]";
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        Object v;
        Object object = v = this.copy ? doc.get(this.from) : doc.remove(this.from);
        if (v != null) {
            doc.setField(this.to, v);
        }
    }

    @Override
    public String[] getExtraRequestFields() {
        return this.ensureFromFieldPresent;
    }
}

