/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Collection;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedFloatFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class FloatPointField
extends PointField
implements FloatValueFieldType {
    public FloatPointField() {
        this.type = NumberType.FLOAT;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof CharSequence) {
            return Float.valueOf(Float.parseFloat(val.toString()));
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        float actualMax;
        float actualMin;
        if (min == null) {
            actualMin = Float.NEGATIVE_INFINITY;
        } else {
            actualMin = FloatPointField.parseFloatFromUser(field.getName(), min);
            if (!minInclusive) {
                if (actualMin == Float.POSITIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMin = FloatPoint.nextUp(actualMin);
            }
        }
        if (max == null) {
            actualMax = Float.POSITIVE_INFINITY;
        } else {
            actualMax = FloatPointField.parseFloatFromUser(field.getName(), max);
            if (!maxInclusive) {
                if (actualMax == Float.NEGATIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMax = FloatPoint.nextDown(actualMax);
            }
        }
        return FloatPoint.newRangeQuery(field.getName(), actualMin, actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return Float.valueOf(FloatPoint.decodeDimension(term.bytes, term.offset));
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                return Float.valueOf(Float.intBitsToFloat(val.intValue()));
            }
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC) {
                return Float.valueOf(NumericUtils.sortableIntToFloat(val.intValue()));
            }
            return val;
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return FloatPoint.newExactQuery(field.getName(), FloatPointField.parseFloatFromUser(field.getName(), externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        float[] values = new float[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = FloatPointField.parseFloatFromUser(field.getName(), val);
            ++i;
        }
        if (field.hasDocValues()) {
            return FloatField.newSetQuery(field.getName(), values);
        }
        return FloatPoint.newSetQuery(field.getName(), values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Float.toString(FloatPoint.decodeDimension(indexedForm.bytes, indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(4);
        result.setLength(4);
        FloatPoint.encodeDimension(FloatPointField.parseFloatFromUser(null, val.toString()), result.bytes(), 0);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.FLOAT_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new FloatFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField f) {
        return new MultiValuedFloatFieldSource(f.getName(), choice);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        float floatValue = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
        return new FloatPoint(field.getName(), floatValue);
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Float)this.toNativeType(value)).floatValue());
    }
}

