/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.FieldType;

public final class SchemaField
extends FieldProperties
implements IndexableFieldType {
    private static final String FIELD_NAME = "name";
    private static final String TYPE_NAME = "type";
    private static final String DEFAULT_VALUE = "default";
    final String name;
    final FieldType type;
    final int properties;
    final String defaultValue;
    boolean required = false;
    Map<String, Object> args = Collections.emptyMap();

    public SchemaField(String name, FieldType type) {
        this(name, type, type.properties, null);
    }

    public SchemaField(SchemaField prototype, String name) {
        this(name, prototype.type, prototype.properties, prototype.defaultValue);
        this.args = prototype.args;
    }

    public SchemaField(String name, FieldType type, int properties, String defaultValue) {
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.defaultValue = defaultValue;
        this.required = (properties & 0x1000) != 0;
        type.checkSchemaField(this);
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public int getProperties() {
        return this.properties;
    }

    public boolean isUninvertible() {
        return (this.properties & 0x80000) != 0;
    }

    public boolean indexed() {
        return (this.properties & 1) != 0;
    }

    @Override
    public boolean stored() {
        return (this.properties & 4) != 0;
    }

    public boolean hasDocValues() {
        return (this.properties & 0x8000) != 0;
    }

    public boolean storeTermVector() {
        return (this.properties & 0x40) != 0;
    }

    public boolean storeTermPositions() {
        return (this.properties & 0x80) != 0;
    }

    public boolean storeTermOffsets() {
        return (this.properties & 0x100) != 0;
    }

    public boolean storeTermPayloads() {
        return (this.properties & 0x10000) != 0;
    }

    @Override
    public boolean omitNorms() {
        return (this.properties & 0x10) != 0;
    }

    public boolean omitTermFreqAndPositions() {
        return (this.properties & 0x20) != 0;
    }

    public boolean omitPositions() {
        return (this.properties & 0x2000) != 0;
    }

    public boolean storeOffsetsWithPositions() {
        return (this.properties & 0x4000) != 0;
    }

    public boolean useDocValuesAsStored() {
        return (this.properties & 0x20000) != 0;
    }

    public boolean multiValued() {
        return (this.properties & 0x200) != 0;
    }

    public boolean sortMissingFirst() {
        return (this.properties & 0x400) != 0;
    }

    public boolean sortMissingLast() {
        return (this.properties & 0x800) != 0;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isLarge() {
        return (this.properties & 0x40000) != 0;
    }

    public Map<String, ?> getArgs() {
        return Collections.unmodifiableMap(this.args);
    }

    boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    boolean isBinary() {
        return (this.properties & 8) != 0;
    }

    public IndexableField createField(Object val) {
        return this.type.createField(this, val);
    }

    public List<IndexableField> createFields(Object val) {
        return this.type.createFields(this, val);
    }

    public boolean isPolyField() {
        return this.type.isPolyField();
    }

    public String toString() {
        return this.name + "{type=" + this.type.getTypeName() + (String)(this.defaultValue == null ? "" : ",default=" + this.defaultValue) + ",properties=" + SchemaField.propertiesToString(this.properties) + (this.required ? ", required=true" : "") + "}";
    }

    public void write(TextResponseWriter writer, String name, IndexableField val) throws IOException {
        this.type.write(writer, name, val);
    }

    public SortField getSortField(boolean top) {
        return this.type.getSortField(this, top);
    }

    public String getPostingsFormat() {
        return (String)this.args.getOrDefault("postingsFormat", this.type.getPostingsFormat());
    }

    public String getDocValuesFormat() {
        return (String)this.args.getOrDefault("docValuesFormat", this.type.getDocValuesFormat());
    }

    public void checkSortability() throws SolrException {
        if (this.multiValued() && null == this.type.getDefaultMultiValueSelectorForSort(this, true) && null == this.type.getDefaultMultiValueSelectorForSort(this, false)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not sort on multivalued field: " + this.getName() + " of type: " + this.type.getTypeName());
        }
        if (!(this.hasDocValues() || this.indexed() && this.isUninvertible() && null != this.type.getUninversionType(this))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not sort on a field w/o docValues unless it is indexed=true uninvertible=true and the type supports Uninversion: " + this.getName());
        }
    }

    public void checkFieldCacheSource() throws SolrException {
        if (this.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not use FieldCache on multivalued field: " + this.getName());
        }
        if (!(this.hasDocValues() || this.indexed() && this.isUninvertible() && null != this.type.getUninversionType(this))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not use FieldCache on a field w/o docValues unless it is indexed uninvertible=true and the type supports Uninversion: " + this.getName());
        }
    }

    static SchemaField create(String name, FieldType ft, Map<String, ?> props) {
        String defaultValue = null;
        if (props.containsKey(DEFAULT_VALUE)) {
            defaultValue = (String)props.get(DEFAULT_VALUE);
        }
        SchemaField field = new SchemaField(name, ft, SchemaField.calcProps(name, ft, props), defaultValue);
        field.args = new HashMap(props);
        return field;
    }

    static SchemaField create(String name, FieldType ft, int props, String defValue) {
        return new SchemaField(name, ft, props, defValue);
    }

    static int calcProps(String name, FieldType ft, Map<String, ?> props) {
        int pp;
        int trueProps = SchemaField.parseProperties(props, true, true);
        int falseProps = SchemaField.parseProperties(props, false, true);
        int p = ft.properties;
        if (SchemaField.on(falseProps, 4)) {
            pp = 262156;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting stored field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 1)) {
            pp = 590273;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting 'true' field options for non-indexed field:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 524288) && SchemaField.on(falseProps, 32768)) {
            pp = 3072;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting 'true' field options for non-docValues/non-uninvertible field:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 1)) {
            pp = 8240;
            if (SchemaField.on(pp, falseProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting 'false' field options for non-indexed field:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(trueProps, 32)) {
            pp = 8224;
            if (SchemaField.on(pp, falseProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting tf and position field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 64)) {
            pp = 65984;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting termvector field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(trueProps, 1024)) {
            p &= 0xFFFFF7FF;
        }
        if (SchemaField.on(trueProps, 2048)) {
            p &= 0xFFFFFBFF;
        }
        p &= ~falseProps;
        return p |= trueProps;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SchemaField && this.name.equals(((SchemaField)obj).name);
    }

    public SimpleOrderedMap<Object> getNamedPropertyValues(boolean showDefaults) {
        SimpleOrderedMap<Object> properties = new SimpleOrderedMap<Object>();
        properties.add(FIELD_NAME, this.getName());
        properties.add(TYPE_NAME, this.getType().getTypeName());
        if (showDefaults) {
            if (null != this.getDefaultValue()) {
                properties.add(DEFAULT_VALUE, this.getDefaultValue());
            }
            properties.add(SchemaField.getPropertyName(1), this.indexed());
            properties.add(SchemaField.getPropertyName(4), this.stored());
            properties.add(SchemaField.getPropertyName(32768), this.hasDocValues());
            properties.add(SchemaField.getPropertyName(64), this.storeTermVector());
            properties.add(SchemaField.getPropertyName(128), this.storeTermPositions());
            properties.add(SchemaField.getPropertyName(256), this.storeTermOffsets());
            properties.add(SchemaField.getPropertyName(65536), this.storeTermPayloads());
            properties.add(SchemaField.getPropertyName(16), this.omitNorms());
            properties.add(SchemaField.getPropertyName(32), this.omitTermFreqAndPositions());
            properties.add(SchemaField.getPropertyName(8192), this.omitPositions());
            properties.add(SchemaField.getPropertyName(16384), this.storeOffsetsWithPositions());
            properties.add(SchemaField.getPropertyName(512), this.multiValued());
            properties.add(SchemaField.getPropertyName(262144), this.isLarge());
            properties.add(SchemaField.getPropertyName(524288), this.isUninvertible());
            if (this.sortMissingFirst()) {
                properties.add(SchemaField.getPropertyName(1024), this.sortMissingFirst());
            } else if (this.sortMissingLast()) {
                properties.add(SchemaField.getPropertyName(2048), this.sortMissingLast());
            }
            properties.add(SchemaField.getPropertyName(4096), this.isRequired());
            properties.add(SchemaField.getPropertyName(2), this.isTokenized());
            properties.add(SchemaField.getPropertyName(131072), this.useDocValuesAsStored());
        } else {
            for (Map.Entry<String, Object> arg : this.args.entrySet()) {
                String key = arg.getKey();
                Object value = arg.getValue();
                if (key.equals(DEFAULT_VALUE)) {
                    properties.add(key, value);
                    continue;
                }
                boolean boolVal = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
                properties.add(key, boolVal);
            }
        }
        return properties;
    }

    @Override
    public boolean tokenized() {
        return this.isTokenized();
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVector();
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermOffsets();
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermPositions();
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermPayloads();
    }

    @Override
    public IndexOptions indexOptions() {
        if (!this.indexed()) {
            return IndexOptions.NONE;
        }
        IndexOptions options = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        if (this.omitTermFreqAndPositions()) {
            options = IndexOptions.DOCS;
        } else if (this.omitPositions()) {
            options = IndexOptions.DOCS_AND_FREQS;
        } else if (this.storeOffsetsWithPositions()) {
            options = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        return options;
    }

    @Override
    public DocValuesType docValuesType() {
        return DocValuesType.NONE;
    }

    @Override
    public int pointDimensionCount() {
        return 0;
    }

    @Override
    public int pointIndexDimensionCount() {
        return 0;
    }

    @Override
    public int pointNumBytes() {
        return 0;
    }

    @Override
    public int vectorDimension() {
        return 0;
    }

    @Override
    public VectorEncoding vectorEncoding() {
        return VectorEncoding.BYTE;
    }

    @Override
    public VectorSimilarityFunction vectorSimilarityFunction() {
        return VectorSimilarityFunction.EUCLIDEAN;
    }

    @Override
    public Map<String, String> getAttributes() {
        return null;
    }
}

