/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;

public class StrFieldSource
extends FieldCacheSource {
    private static int hcode = StrFieldSource.class.hashCode();

    public StrFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "str(" + this.field + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public int ordVal(int doc) throws IOException {
                return this.getOrdForDoc(doc);
            }

            @Override
            public int numOrd() {
                return this.termsIndex.getValueCount();
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                return this.strVal(doc);
            }

            @Override
            public String toString(int doc) throws IOException {
                return StrFieldSource.this.description() + "=" + this.strVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof StrFieldSource && super.equals(o);
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode();
    }
}

