/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;

@Deprecated
public class TrieIntField
extends TrieField
implements IntValueFieldType {
    public TrieIntField() {
        this.type = NumberType.INTEGER;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            if (val instanceof CharSequence) {
                return Integer.parseInt(val.toString());
            }
        }
        catch (NumberFormatException e) {
            Float v = Float.valueOf(Float.parseFloat(val.toString()));
            return v.intValue();
        }
        return super.toNativeType(val);
    }

    @Override
    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField f) {
        return new SortedSetFieldSource(f.getName(), choice){

            @Override
            public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
                1 thisAsSortedSetFieldSource = this;
                SortedSetDocValues sortedSet = DocValues.getSortedSet(readerContext.reader(), this.field);
                final SortedDocValues view = SortedSetSelector.wrap(sortedSet, this.selector);
                return new IntDocValues(thisAsSortedSetFieldSource){
                    private int lastDocID;

                    private boolean setDoc(int docID) throws IOException {
                        if (docID < this.lastDocID) {
                            throw new IllegalArgumentException("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID);
                        }
                        if (docID > view.docID()) {
                            this.lastDocID = docID;
                            return docID == view.advance(docID);
                        }
                        return docID == view.docID();
                    }

                    @Override
                    public int intVal(int doc) throws IOException {
                        if (this.setDoc(doc)) {
                            BytesRef bytes = view.lookupOrd(view.ordValue());
                            assert (bytes.length > 0);
                            return LegacyNumericUtils.prefixCodedToInt(bytes);
                        }
                        return 0;
                    }

                    @Override
                    public boolean exists(int doc) throws IOException {
                        return this.setDoc(doc);
                    }

                    @Override
                    public FunctionValues.ValueFiller getValueFiller() {
                        return new FunctionValues.ValueFiller(){
                            private final MutableValueInt mval = new MutableValueInt();

                            @Override
                            public MutableValue getValue() {
                                return this.mval;
                            }

                            @Override
                            public void fillValue(int doc) throws IOException {
                                if (this.setDoc(doc)) {
                                    this.mval.exists = true;
                                    this.mval.value = LegacyNumericUtils.prefixCodedToInt(view.lookupOrd(view.ordValue()));
                                } else {
                                    this.mval.exists = false;
                                    this.mval.value = 0;
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

