/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkIndexSchemaReader
implements OnReconnect {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ManagedIndexSchemaFactory managedIndexSchemaFactory;
    private SolrZkClient zkClient;
    private String managedSchemaPath;
    private final String uniqueCoreId;
    private SchemaWatcher schemaWatcher;
    private ZkSolrResourceLoader zkLoader;

    public ZkIndexSchemaReader(ManagedIndexSchemaFactory managedIndexSchemaFactory, SolrCore solrCore) {
        this.managedIndexSchemaFactory = managedIndexSchemaFactory;
        this.zkLoader = (ZkSolrResourceLoader)managedIndexSchemaFactory.getResourceLoader();
        this.zkClient = this.zkLoader.getZkController().getZkClient();
        this.managedSchemaPath = managedIndexSchemaFactory.lookupZKManagedSchemaPath();
        this.uniqueCoreId = solrCore.getName() + ":" + solrCore.getStartNanoTime();
        solrCore.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
                CoreContainer cc = core.getCoreContainer();
                if (cc.isZooKeeperAware()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing ZkIndexSchemaReader OnReconnect listener as core {} is shutting down.", (Object)core.getName());
                    }
                    cc.getZkController().removeOnReconnectListener(ZkIndexSchemaReader.this);
                }
            }

            @Override
            public void postClose(SolrCore core) {
                ZkIndexSchemaReader.this.schemaWatcher.discardReaderReference();
            }
        });
        this.schemaWatcher = this.createSchemaWatcher();
        this.zkLoader.getZkController().addOnReconnectListener(this);
    }

    public Object getSchemaUpdateLock() {
        return this.managedIndexSchemaFactory.getSchemaUpdateLock();
    }

    public SchemaWatcher createSchemaWatcher() {
        log.info("Creating ZooKeeper watch for the managed schema at {}", (Object)this.managedSchemaPath);
        SchemaWatcher watcher = new SchemaWatcher(this);
        try {
            this.zkClient.exists(this.managedSchemaPath, watcher, true);
        }
        catch (KeeperException e) {
            String msg = "Error creating ZooKeeper watch for the managed schema";
            log.error("Error creating ZooKeeper watch for the managed schema", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Error creating ZooKeeper watch for the managed schema", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", (Throwable)e);
        }
        return watcher;
    }

    public ManagedIndexSchema refreshSchemaFromZk(int expectedZkVersion) throws KeeperException, InterruptedException {
        this.updateSchema(null, expectedZkVersion);
        return this.managedIndexSchemaFactory.getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSchema(Watcher watcher, int expectedZkVersion) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        Object object = this.getSchemaUpdateLock();
        synchronized (object) {
            ManagedIndexSchema oldSchema = this.managedIndexSchemaFactory.getSchema();
            if (expectedZkVersion == -1 || oldSchema.schemaZkVersion < expectedZkVersion) {
                byte[] data = this.zkClient.getData(this.managedSchemaPath, watcher, stat, true);
                if (stat.getVersion() != oldSchema.schemaZkVersion) {
                    if (log.isInfoEnabled()) {
                        log.info("Retrieved schema version {} from Zookeeper", (Object)stat.getVersion());
                    }
                    long start = System.nanoTime();
                    String resourceName = this.managedIndexSchemaFactory.getManagedSchemaResourceName();
                    ManagedIndexSchema newSchema = new ManagedIndexSchema(this.managedIndexSchemaFactory.getConfig(), resourceName, () -> IndexSchemaFactory.getParsedSchema(new ByteArrayInputStream(data), this.zkLoader, resourceName), this.managedIndexSchemaFactory.isMutable(), resourceName, stat.getVersion(), oldSchema.getSchemaUpdateLock());
                    this.managedIndexSchemaFactory.setSchema(newSchema);
                    long stop = System.nanoTime();
                    log.info("Finished refreshing schema in {} ms", (Object)TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS));
                } else {
                    log.info("Current schema version {} is already the latest", (Object)oldSchema.schemaZkVersion);
                }
            }
        }
    }

    @Override
    public void command() {
        try {
            this.schemaWatcher = this.createSchemaWatcher();
            this.updateSchema(null, -1);
        }
        catch (Exception exc) {
            log.error("Failed to update managed schema watcher after session expiration due to: {}", (Throwable)exc);
        }
    }

    public String getUniqueCoreId() {
        return this.uniqueCoreId;
    }

    public String toString() {
        return "ZkIndexSchemaReader: " + this.managedSchemaPath + ", uniqueCoreId: " + this.uniqueCoreId;
    }

    public int hashCode() {
        return this.managedSchemaPath.hashCode() + this.uniqueCoreId.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ZkIndexSchemaReader)) {
            return false;
        }
        ZkIndexSchemaReader that = (ZkIndexSchemaReader)other;
        return this.managedSchemaPath.equals(that.managedSchemaPath) && this.uniqueCoreId.equals(that.uniqueCoreId);
    }

    public static class SchemaWatcher
    implements Watcher {
        private ZkIndexSchemaReader schemaReader;

        public SchemaWatcher(ZkIndexSchemaReader reader) {
            this.schemaReader = reader;
        }

        public void process(WatchedEvent event) {
            ZkIndexSchemaReader indexSchemaReader = this.schemaReader;
            if (indexSchemaReader == null) {
                return;
            }
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            log.info("A schema change: {}, has occurred - updating schema from ZooKeeper ...", (Object)event);
            try {
                indexSchemaReader.updateSchema(this, -1);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                    return;
                }
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("", (Throwable)e);
            }
        }

        public void discardReaderReference() {
            this.schemaReader = null;
        }
    }
}

